/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.model.impl.DirtyPropertyIterator;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;

public class ListProperty
extends AbstractProperty
implements List<Property> {
    private static final long serialVersionUID = 1L;
    protected final Field field;
    protected final List<Property> children;

    public ListProperty(Property parent, Field field) {
        super(parent);
        this.field = field;
        this.children = new ArrayList<Property>();
    }

    public ListProperty(Property parent, Field field, int flags) {
        super(parent, flags);
        this.field = field;
        this.children = new ArrayList<Property>();
    }

    @Override
    public void internalSetValue(Serializable value) throws PropertyException {
    }

    @Override
    public boolean isContainer() {
        return !this.getType().isScalarList();
    }

    @Override
    public Property addValue(int index, Object value) throws PropertyException {
        Field lfield = this.getType().getField();
        Property property = this.getRoot().createProperty(this, lfield, 1);
        property.setValue(value);
        this.children.add(index, property);
        return property;
    }

    @Override
    public Property addValue(Object value) throws PropertyException {
        Field lfield = this.getType().getField();
        Property property = this.getRoot().createProperty(this, lfield, 1);
        property.setValue(value);
        this.children.add(property);
        return property;
    }

    @Override
    public Property addEmpty() {
        Field lfield = this.getType().getField();
        Property property = this.getRoot().createProperty(this, lfield, 0);
        this.children.add(property);
        return property;
    }

    @Override
    public Collection<Property> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    @Override
    public String getName() {
        return this.field.getName().getPrefixedName();
    }

    public ListType getType() {
        return (ListType)this.field.getType();
    }

    @Override
    public Property get(String name) {
        try {
            return this.get(Integer.parseInt(name));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Property get(int index) {
        try {
            return this.children.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    protected Serializable getDefaultValue() {
        ArrayList value = (ArrayList)this.field.getDefaultValue();
        if (value == null) {
            value = new ArrayList();
        }
        return value;
    }

    @Override
    public Serializable internalGetValue() throws PropertyException {
        if (this.children.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>(this.children.size());
        for (Property property : this.children) {
            list.add(property.getValue());
        }
        return list;
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        if (this.isPhantom() || this.isRemoved()) {
            return this.getDefaultValue();
        }
        if (this.children.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>(this.children.size());
        for (Property property : this.children) {
            list.add(property.getValueForWrite());
        }
        return list;
    }

    @Override
    public void init(Serializable value) throws PropertyException {
        if (value == null) {
            return;
        }
        List list = value.getClass().isArray() ? PrimitiveArrays.toList((Object)value) : (List)((Object)value);
        this.children.clear();
        Field lfield = this.getType().getField();
        for (Serializable obj : list) {
            Property property = this.getRoot().createProperty(this, lfield, 0);
            property.init(obj);
            this.children.add(property);
        }
        this.removePhantomFlag();
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        Collection<Object> col;
        if (this.isReadOnly()) {
            throw new ReadOnlyPropertyException(this.getPath());
        }
        if (value == null) {
            ArrayList<Property> temp = new ArrayList<Property>(this.children);
            for (Property p : temp) {
                p.remove();
            }
            return;
        }
        Class<?> klass = value.getClass();
        if (klass == ListDiff.class) {
            this.applyListDiff((ListDiff)value);
            return;
        }
        if (klass.isArray()) {
            col = ListProperty.arrayToList(value);
        } else if (value instanceof Collection) {
            col = (Collection)value;
        } else {
            throw new InvalidPropertyValueException(this.getPath());
        }
        this.clear();
        Field lfield = this.getType().getField();
        for (Object obj : col) {
            Property property = this.getRoot().createProperty(this, lfield, 1);
            property.setValue(obj);
            this.children.add(property);
        }
    }

    @Override
    public void clear() {
        this.children.clear();
        this.setIsModified();
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public boolean remove(Property property) {
        if (!this.children.remove(property)) {
            return false;
        }
        this.setIsModified();
        return true;
    }

    @Override
    public Property remove(int index) {
        Property property = this.children.remove(index);
        this.setIsModified();
        return property;
    }

    public Object clone() throws CloneNotSupportedException {
        ListProperty clone = (ListProperty)super.clone();
        return clone;
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws PropertyException {
        if ((arg = visitor.visit(this, arg)) != null && this.isContainer()) {
            for (Property property : this.children) {
                property.accept(visitor, arg);
            }
        }
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof Collection && value instanceof Serializable;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        if (value.getClass().isArray()) {
            return ListProperty.arrayToList(value);
        }
        throw new PropertyConversionException(value.getClass(), List.class);
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (value == null) {
            return null;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            return toType.cast(value);
        }
        if (toType.isArray()) {
            return (T)((Collection)((Object)value)).toArray();
        }
        if ((toType == List.class || toType == Collection.class) && value.getClass().isArray()) {
            if (value.getClass().isPrimitive()) {
                return (T)PrimitiveArrays.toList((Object)value);
            }
            return (T)Arrays.asList((Object[])value);
        }
        return super.convertTo(value, toType);
    }

    public static ArrayList<?> arrayToList(Object obj) {
        Object[] ar = PrimitiveArrays.toObjectArray((Object)obj);
        ArrayList<Object> list = new ArrayList<Object>(ar.length);
        list.addAll(Arrays.asList(ar));
        return list;
    }

    public void applyListDiff(ListDiff ld) throws PropertyException {
        block8: for (ListDiff.Entry entry : ld.diff()) {
            switch (entry.type) {
                case 1: {
                    this.addValue(entry.value);
                    continue block8;
                }
                case 2: {
                    this.addValue(entry.index, entry.value);
                    continue block8;
                }
                case 3: {
                    this.remove(entry.index);
                    continue block8;
                }
                case 6: {
                    this.clear();
                    continue block8;
                }
                case 4: {
                    this.get(entry.index).setValue(entry.value);
                    continue block8;
                }
                case 5: {
                    int toIndex = (Integer)entry.value;
                    int fromIndex = entry.index;
                    Property src = this.children.get(fromIndex);
                    src.moveTo(toIndex);
                }
            }
        }
    }

    @Override
    public boolean isSameAs(Property property) throws PropertyException {
        if (!(property instanceof ListProperty)) {
            return false;
        }
        ListProperty lp = (ListProperty)property;
        List<Property> c1 = this.children;
        List<Property> c2 = lp.children;
        if (c1.size() != c2.size()) {
            return false;
        }
        int size = c1.size();
        for (int i = 0; i < size; ++i) {
            Property p2;
            Property p1 = c1.get(i);
            if (p1.isSameAs(p2 = c2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Property> getDirtyChildren() {
        if (!this.isContainer()) {
            throw new UnsupportedOperationException("Cannot iterate over children of scalar properties");
        }
        return new DirtyPropertyIterator(this.children.iterator());
    }

    public int indexOf(Property property) {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Property p = this.children.get(i);
            if (p != property) continue;
            return i;
        }
        return -1;
    }

    boolean moveTo(Property property, int index) {
        if (index < 0 || index > this.children.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ". Bounds are: 0 - " + this.children.size());
        }
        int i = this.indexOf(property);
        if (i == -1) {
            throw new UnsupportedOperationException("You are trying to move a property that is not part of a list");
        }
        if (i == index) {
            return false;
        }
        if (i < index) {
            this.children.add(index + 1, property);
            this.children.remove(i);
        } else {
            this.children.add(index, property);
            this.children.remove(i + 1);
        }
        for (int j = Math.min(index, i); j < this.children.size(); ++j) {
            ((AbstractProperty)this.children.get(j)).setIsModified();
        }
        return true;
    }

    @Override
    public void add(int index, Property element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Property o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Property> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Property> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Property> listIterator() {
        return this.children.listIterator();
    }

    @Override
    public ListIterator<Property> listIterator(int index) {
        return this.children.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property set(int index, Property element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Property> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.children.toArray(a);
    }

    @Override
    public void clearDirtyFlags() {
        super.clearDirtyFlags();
        for (Property child : this.children) {
            child.clearDirtyFlags();
        }
    }
}

