/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.Metadata;

public final class Tag
extends Metadata {
    public static final Tag ALL = Tag.parse("*");
    private boolean weak;

    public static Tag parse(String httpTag) {
        Tag result = null;
        boolean weak = false;
        String httpTagCopy = httpTag;
        if (httpTagCopy.startsWith("W/")) {
            weak = true;
            httpTagCopy = httpTagCopy.substring(2);
        }
        if (httpTagCopy.startsWith("\"") && httpTagCopy.endsWith("\"")) {
            result = new Tag(httpTagCopy.substring(1, httpTagCopy.length() - 1), weak);
        } else if (httpTagCopy.equals("*")) {
            result = new Tag("*", weak);
        } else {
            Logger.getLogger(Tag.class.getCanonicalName()).log(Level.WARNING, "Invalid tag format detected: " + httpTagCopy);
        }
        return result;
    }

    public Tag() {
        this(null, true);
    }

    public Tag(String opaqueTag) {
        this(opaqueTag, true);
    }

    public Tag(String opaqueTag, boolean weak) {
        super(opaqueTag);
        this.weak = weak;
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean checkWeakness) {
        boolean result;
        boolean bl = result = object != null && object instanceof Tag;
        if (result) {
            Tag that = (Tag)object;
            if (checkWeakness) {
                boolean bl2 = result = that.isWeak() == this.isWeak();
            }
            result = this.getName() == null ? that.getName() == null : this.getName().equals(that.getName());
        }
        return result;
    }

    public String format() {
        if (this.getName().equals("*")) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isWeak()) {
            sb.append("W/");
        }
        return sb.append('\"').append(this.getName()).append('\"').toString();
    }

    public String getDescription() {
        return "Validation tag equivalent to an HTTP entity tag";
    }

    public String getName() {
        return super.getName();
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean isWeak() {
        return this.weak;
    }
}

