/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.elasticsearch;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Elasticsearch.WaitForIndexing", category="Services", label="Wait for Elasticsearch Indexing", since="8.1", description="Wait until Elasticsearch indexing is done.")
public class ElasticsearchWaitForIndexingOperation {
    public static final String ID = "Elasticsearch.WaitForIndexing";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected ElasticSearchAdmin esa;
    @Context
    protected CoreSession repo;
    @Param(name="timeoutSecond", required=false)
    protected Integer timeout = 60;
    @Param(name="refresh", required=false)
    protected Boolean refresh = false;

    @OperationMethod
    public Boolean run() {
        long start = System.currentTimeMillis();
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        try {
            if (!workManager.awaitCompletion((long)this.timeout.intValue(), TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            this.esa.prepareWaitForIndexing().get(this.computeRemainingTime(start), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return Boolean.FALSE;
        }
        catch (InterruptedException e) {
            return Boolean.FALSE;
        }
        catch (ExecutionException e) {
            return Boolean.FALSE;
        }
        if (this.refresh.booleanValue()) {
            this.esa.refreshRepositoryIndex(this.repo.getRepositoryName());
        }
        return Boolean.TRUE;
    }

    protected long computeRemainingTime(long start) {
        long elapsed = System.currentTimeMillis() - start;
        return Long.max((long)this.timeout.intValue() - TimeUnit.MILLISECONDS.toSeconds(elapsed), 1L);
    }
}

