/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadComponent;

public class NuxeoRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restart() throws IOException {
        String home;
        ArrayList<String> cmd = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        File java = new File(new File(javaHome), "bin/java").getCanonicalFile();
        if (java.isFile()) {
            cmd.add(java.getAbsolutePath());
        } else {
            cmd.add("java");
        }
        File bundle = Framework.getRuntime().getBundleFile(ReloadComponent.getBundle());
        cmd.add("-cp");
        cmd.add(bundle.getAbsolutePath());
        cmd.add(NuxeoRestart.class.getName());
        Environment env = Environment.getDefault();
        if (env.isJBoss()) {
            home = System.getProperty("jboss.home.dir");
            File bin = new File(home, "bin");
            File file = new File(bin, "nuxeoctl").getCanonicalFile();
            if (file.isFile()) {
                cmd.add(file.getAbsolutePath());
                cmd.add("start");
            } else {
                file = new File(bin, "jbossctl").getCanonicalFile();
                if (file.isFile()) {
                    cmd.add(file.getAbsolutePath());
                    cmd.add("start");
                }
            }
        } else if (env.isTomcat()) {
            home = System.getProperty("catalina.base");
            File bin = new File(home, "bin");
            File file = new File(bin, "nuxeoctl").getCanonicalFile();
            if (file.isFile()) {
                cmd.add(file.getAbsolutePath());
                cmd.add("start");
            } else {
                file = new File(bin, "catalina.sh").getCanonicalFile();
                if (file.isFile()) {
                    cmd.add(file.getAbsolutePath());
                    cmd.add("start");
                }
            }
        } else {
            File file = new File(env.getHome(), "bin/nuxeoctl").getCanonicalFile();
            if (file.isFile()) {
                cmd.add(file.getAbsolutePath());
                cmd.add("start");
            } else {
                file = new File(env.getHome(), "nxserverctl.sh").getCanonicalFile();
                if (file.isFile()) {
                    cmd.add(file.getAbsolutePath());
                    cmd.add("start");
                }
            }
        }
        if (cmd.size() <= 1) {
            throw new FileNotFoundException("Could not find startup script");
        }
        File lock = Framework.createTempFile((String)"nx-restart", (String)".lock").getCanonicalFile();
        lock.deleteOnExit();
        cmd.add(lock.getAbsolutePath());
        new ProcessBuilder(new String[0]).command(cmd).start();
        try {
            Framework.shutdown();
        }
        finally {
            System.exit(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: RestartNuxeo script lock");
            System.exit(1);
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 0, newArgs, 0, newArgs.length);
        File lock = new File(args[args.length - 1]);
        File script = new File(args[0]);
        boolean ok = false;
        try {
            while (lock.isFile()) {
                Thread.sleep(2000L);
            }
            Thread.sleep(1000L);
            Runtime.getRuntime().exec(newArgs, new String[]{"JAVA_HOME=" + System.getProperty("java.home")}, script.getParentFile());
            ok = true;
        }
        finally {
            if (!ok) {
                System.exit(2);
            }
        }
    }
}

