/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;

@XObject(value="tableReference")
public class TableReference
extends AbstractReference
implements Cloneable {
    @XNode(value="@table")
    protected String tableName;
    @XNode(value="@sourceColumn")
    protected String sourceColumn;
    @XNode(value="@targetColumn")
    protected String targetColumn;
    @XNode(value="@schema")
    protected String schemaName;
    @XNode(value="@dataFile")
    protected String dataFileName;
    private Table table;
    private Dialect dialect;
    private boolean initialized = false;

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    private SQLDirectory getSQLSourceDirectory() throws DirectoryException {
        Directory dir = this.getSourceDirectory();
        return (SQLDirectory)dir;
    }

    private void initialize(SQLSession sqlSession) throws DirectoryException {
        SQLDirectory directory = this.getSQLSourceDirectory();
        String createTablePolicy = directory.getDescriptor().createTablePolicy;
        Table table = this.getTable();
        SQLHelper helper = new SQLHelper(sqlSession.sqlConnection, table, this.dataFileName, createTablePolicy);
        helper.setupTable();
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        if (targetIds == null) {
            return;
        }
        try (SQLSession session = this.getSQLSession();){
            this.addLinks(sourceId, targetIds, session);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        if (sourceIds == null) {
            return;
        }
        try (SQLSession session = this.getSQLSession();){
            this.addLinks(sourceIds, targetId, session);
        }
    }

    public void addLinks(String sourceId, List<String> targetIds, SQLSession session) throws DirectoryException {
        if (targetIds == null) {
            return;
        }
        for (String targetId : targetIds) {
            this.addLink(sourceId, targetId, session, true);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId, SQLSession session) throws DirectoryException {
        if (sourceIds == null) {
            return;
        }
        for (String sourceId : sourceIds) {
            this.addLink(sourceId, targetId, session, true);
        }
    }

    public boolean exists(String sourceId, String targetId, SQLSession session) throws DirectoryException {
        Table table = this.getTable();
        Select select = new Select(table);
        select.setFrom(table.getQuotedName());
        select.setWhat("count(*)");
        String whereString = String.format("%s = ? and %s = ?", table.getColumn(this.sourceColumn).getQuotedName(), table.getColumn(this.targetColumn).getQuotedName());
        select.setWhere(whereString);
        String selectSql = select.getStatement();
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(selectSql, Arrays.asList(sourceId, targetId));
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = session.sqlConnection.prepareStatement(selectSql);
            ps.setString(1, sourceId);
            ps.setString(2, targetId);
            rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error reading link from %s to %s", sourceId, targetId), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public void addLink(String sourceId, String targetId, SQLSession session, boolean checkExisting) throws DirectoryException {
        if (checkExisting && this.exists(sourceId, targetId, session)) {
            return;
        }
        Table table = this.getTable();
        Insert insert = new Insert(table);
        insert.addColumn(table.getColumn(this.sourceColumn));
        insert.addColumn(table.getColumn(this.targetColumn));
        String insertSql = insert.getStatement();
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(insertSql, Arrays.asList(sourceId, targetId));
        }
        PreparedStatement ps = null;
        try {
            ps = session.sqlConnection.prepareStatement(insertSql);
            ps.setString(1, sourceId);
            ps.setString(2, targetId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error adding link from %s to %s", sourceId, targetId), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected List<String> getIdsFor(String valueColumn, String filterColumn, String filterValue) throws DirectoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        return this.getIdsFor(this.sourceColumn, this.targetColumn, targetId);
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        return this.getIdsFor(this.targetColumn, this.sourceColumn, sourceId);
    }

    public void removeLinksFor(String column, String entryId, SQLSession session) throws DirectoryException {
        Table table = this.getTable();
        String sql = String.format("DELETE FROM %s WHERE %s = ?", table.getQuotedName(), table.getColumn(column).getQuotedName());
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(sql, Collections.singleton(entryId));
        }
        PreparedStatement ps = null;
        try {
            ps = session.sqlConnection.prepareStatement(sql);
            ps.setString(1, entryId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("error remove links to " + entryId, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public void removeLinksForSource(String sourceId, SQLSession session) throws DirectoryException {
        this.removeLinksFor(this.sourceColumn, sourceId, session);
    }

    public void removeLinksForTarget(String targetId, SQLSession session) throws DirectoryException {
        this.removeLinksFor(this.targetColumn, targetId, session);
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        try (SQLSession session = this.getSQLSession();){
            this.removeLinksForSource(sourceId, session);
        }
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        try (SQLSession session = this.getSQLSession();){
            this.removeLinksForTarget(targetId, session);
        }
    }

    public void setIdsFor(String idsColumn, List<String> ids, String filterColumn, String filterValue, SQLSession session) throws DirectoryException {
        block32: {
            LinkedList<String> idsToDelete = new LinkedList<String>();
            HashSet<String> idsToAdd = new HashSet<String>();
            if (ids != null) {
                idsToAdd.addAll(ids);
            }
            Table table = this.getTable();
            String selectSql = String.format("SELECT %s FROM %s WHERE %s = ?", table.getColumn(idsColumn).getQuotedName(), table.getQuotedName(), table.getColumn(filterColumn).getQuotedName());
            PreparedStatement ps = null;
            try {
                ps = session.sqlConnection.prepareStatement(selectSql);
                ps.setString(1, filterValue);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String existingId = rs.getString(1);
                    if (idsToAdd.contains(existingId)) {
                        idsToAdd.remove(existingId);
                        continue;
                    }
                    idsToDelete.add(existingId);
                }
                rs.close();
            }
            catch (SQLException e) {
                throw new DirectoryException("failed to fetch existing links for " + filterValue, (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new DirectoryException((Throwable)sqle);
                }
            }
            if (!idsToDelete.isEmpty()) {
                Delete delete = new Delete(table);
                String whereString = String.format("%s = ? AND %s = ?", table.getColumn(filterColumn).getQuotedName(), table.getColumn(idsColumn).getQuotedName());
                delete.setWhere(whereString);
                String deleteSql = delete.getStatement();
                try {
                    ps = session.sqlConnection.prepareStatement(deleteSql);
                    for (String unwantedId : idsToDelete) {
                        if (session.logger.isLogEnabled()) {
                            session.logger.logSQL(deleteSql, Arrays.asList(filterValue, unwantedId));
                        }
                        ps.setString(1, filterValue);
                        ps.setString(2, unwantedId);
                        ps.execute();
                    }
                }
                catch (SQLException e) {
                    throw new DirectoryException("failed to remove unwanted links for " + filterValue, (Throwable)e);
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException sqle) {
                        throw new DirectoryException((Throwable)sqle);
                    }
                }
            }
            if (idsToAdd.isEmpty()) break block32;
            if (filterColumn.equals(this.sourceColumn)) {
                for (String missingId : idsToAdd) {
                    this.addLink(filterValue, missingId, session, false);
                }
            } else {
                for (String missingId : idsToAdd) {
                    this.addLink(missingId, filterValue, session, false);
                }
            }
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, SQLSession session) throws DirectoryException {
        this.setIdsFor(this.sourceColumn, sourceIds, this.targetColumn, targetId, session);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, SQLSession session) throws DirectoryException {
        this.setIdsFor(this.targetColumn, targetIds, this.sourceColumn, sourceId, session);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        try (SQLSession session = this.getSQLSession();){
            this.setSourceIdsForTarget(targetId, sourceIds, session);
        }
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        try (SQLSession session = this.getSQLSession();){
            this.setTargetIdsForSource(sourceId, targetIds, session);
        }
    }

    protected SQLSession getSQLSession() throws DirectoryException {
        if (!this.initialized) {
            try (SQLSession sqlSession = (SQLSession)this.getSourceDirectory().getSession();){
                this.initialize(sqlSession);
                this.initialized = true;
            }
        }
        return (SQLSession)this.getSourceDirectory().getSession();
    }

    protected void maybeInitialize(SQLSession sqlSession) throws DirectoryException {
        if (!this.initialized) {
            this.initialize(sqlSession);
            this.initialized = true;
        }
    }

    public Table getTable() throws DirectoryException {
        if (this.table == null) {
            boolean nativeCase = this.getSQLSourceDirectory().useNativeCase();
            this.table = SQLHelper.addTable(this.tableName, this.getDialect(), nativeCase);
            SQLHelper.addColumn(this.table, this.sourceColumn, ColumnType.STRING, nativeCase);
            SQLHelper.addColumn(this.table, this.targetColumn, ColumnType.STRING, nativeCase);
            this.table.addIndex(null, Table.IndexType.MAIN_NON_PRIMARY, new String[]{this.sourceColumn});
        }
        return this.table;
    }

    private Dialect getDialect() throws DirectoryException {
        if (this.dialect == null) {
            this.dialect = this.getSQLSourceDirectory().getDialect();
        }
        return this.dialect;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public TableReference clone() {
        TableReference clone = (TableReference)super.clone();
        return clone;
    }
}

