/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectorySession;
import org.nuxeo.ecm.directory.multi.MultiReference;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MultiDirectory
extends AbstractDirectory {
    public MultiDirectory(MultiDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor);
    }

    public MultiDirectoryDescriptor getDescriptor() {
        return (MultiDirectoryDescriptor)this.descriptor;
    }

    public Session getSession() throws DirectoryException {
        MultiDirectorySession session = new MultiDirectorySession(this);
        this.addSession((Session)session);
        return session;
    }

    public List<Reference> getReferences(String referenceFieldName) {
        MultiReference reference = new MultiReference(this, referenceFieldName);
        return Collections.singletonList(reference);
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        this.getCache().invalidateAll();
        for (SourceDescriptor src : this.getDescriptor().sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                Directory dir = dirService.getDirectory(sub.name);
                if (dir == null) continue;
                dir.invalidateDirectoryCache();
            }
        }
    }
}

