/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.DefaultDirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.registry.LDAPServerRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;

public class LDAPDirectoryFactory
extends DefaultDirectoryFactory {
    public static final String SERVERS_XP = "servers";
    protected LDAPServerRegistry servers = new LDAPServerRegistry();

    public LDAPServerDescriptor getServer(String name) {
        return this.servers.getServer(name);
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getLocalService(DirectoryService.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("directories".equals(extensionPoint)) {
            super.registerContribution(contribution, extensionPoint, contributor);
        } else if (SERVERS_XP.equals(extensionPoint)) {
            this.registerServerContribution((LDAPServerDescriptor)contribution);
        } else {
            throw new NuxeoException("Unknown extension point: " + extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("directories".equals(extensionPoint)) {
            super.unregisterContribution(contribution, extensionPoint, contributor);
        } else if (SERVERS_XP.equals(extensionPoint)) {
            this.unregisterServerContribution((LDAPServerDescriptor)contribution);
        }
    }

    public void registerServerContribution(LDAPServerDescriptor descriptor) {
        this.servers.addContribution(descriptor);
    }

    public void unregisterServerContribution(LDAPServerDescriptor descriptor) {
        this.servers.removeContribution(descriptor);
    }
}

