/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deprecated
@Operation(id="RunOperationOnListInNewTx", category="Execution Flow", label="Run For Each in new TX", description="Run an operation/chain in a new Transaction for each element from the list defined by the 'list' parameter. The 'list' parameter is pointing to a context variable that represents the list which will be iterated. The 'itemName' parameter represents the name of the context variable which will point to the current element in the list at each iteration. You can use the 'isolate' parameter to specify whether or not the evalution context is the same as the parent context or a copy of it. If the 'isolate' parameter is 'true' then a copy of the current context is used and so that modifications in this context will not affect the parent context. Any input is accepted. The input is returned back as output when operation terminates.", deprecatedSince="6.0", aliases={"Context.RunOperationOnListInNewTx"})
public class RunOperationOnListInNewTransaction {
    protected static Log log = LogFactory.getLog(RunOperationOnListInNewTransaction.class);
    public static final String ID = "RunOperationOnListInNewTx";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="list")
    protected String listName;
    @Param(name="itemName", required=false, values={"item"})
    protected String itemName = "item";
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws OperationException {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        Collection<Object> list = null;
        if (this.ctx.get(this.listName) instanceof Object[]) {
            list = Arrays.asList((Object[])this.ctx.get(this.listName));
        } else if (this.ctx.get(this.listName) instanceof Collection) {
            list = (Collection)this.ctx.get(this.listName);
        } else {
            throw new UnsupportedOperationException(this.ctx.get(this.listName).getClass() + " is not a Collection");
        }
        TransactionHelper.commitOrRollbackTransaction();
        for (Object e : list) {
            TransactionHelper.startTransaction();
            boolean completedAbruptly = true;
            try {
                OperationContext subctx = new OperationContext(this.session, vars);
                subctx.setInput(this.ctx.getInput());
                subctx.put(this.itemName, e);
                this.service.run(subctx, this.chainId, null);
                completedAbruptly = false;
            }
            finally {
                if (completedAbruptly) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        TransactionHelper.startTransaction();
        if (!this.isolate) {
            for (String string : vars.keySet()) {
                if (!this.ctx.getVars().containsKey(string)) {
                    this.ctx.put(string, vars.get(string));
                    continue;
                }
                Object value = vars.get(string);
                if (this.session != null && value != null && value instanceof DocumentModel) {
                    this.ctx.getVars().put(string, this.session.getDocument(((DocumentModel)value).getRef()));
                    continue;
                }
                this.ctx.getVars().put(string, value);
            }
        }
    }
}

