/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;

@Operation(id="Event.Fire", category="Notification", label="Send Event", description="Send a Nuxeo event.", aliases={"Notification.SendEvent"})
public class FireEvent {
    public static final String ID = "Event.Fire";
    @Context
    protected OperationContext ctx;
    @Context
    protected EventProducer service;
    @Param(name="name")
    protected String name;

    @OperationMethod
    public void run() {
        CoreSession session = this.ctx.getCoreSession();
        Object input = this.ctx.getInput();
        if (input instanceof DocumentModel) {
            this.sendDocumentEvent((DocumentModel)input);
        } else if (input instanceof DocumentRef) {
            this.sendDocumentEvent(session.getDocument((DocumentRef)input));
        } else if (input instanceof DocumentModelList) {
            DocumentModelList docs = (DocumentModelList)input;
            for (DocumentModel documentModel : docs) {
                this.sendDocumentEvent(documentModel);
            }
        } else {
            this.sendUnknownEvent(input);
        }
    }

    protected void sendDocumentEvent(DocumentModel input) {
        CoreSession session = this.ctx.getCoreSession();
        DocumentEventContext evctx = new DocumentEventContext(session, session.getPrincipal(), input);
        Event event = evctx.newEvent(this.name);
        this.service.fireEvent(event);
    }

    protected void sendUnknownEvent(Object input) {
        CoreSession session = this.ctx.getCoreSession();
        EventContextImpl evctx = new EventContextImpl(session, session.getPrincipal(), new Object[]{input});
        Event event = evctx.newEvent(this.name);
        this.service.fireEvent(event);
    }
}

