/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

@Name(value="renditionAction")
@Scope(value=ScopeType.PAGE)
public class RenditionActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RENDITION_REST_URL_FORMAT = "%sapi/v1/id/%s/@rendition/%s";
    @In(create=true)
    protected transient NavigationContext navigationContext;

    @Factory(value="currentDocumentRenditions", scope=ScopeType.EVENT)
    public List<Rendition> getCurrentDocumentRenditions() throws Exception {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        RenditionService rs = (RenditionService)Framework.getLocalService(RenditionService.class);
        return rs.getAvailableRenditions(doc);
    }

    @Factory(value="currentDocumentVisibleRenditionDefinitions", scope=ScopeType.EVENT)
    public List<RenditionDefinition> getVisibleRenditionDefinitions() throws Exception {
        ArrayList<RenditionDefinition> result = new ArrayList<RenditionDefinition>();
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        RenditionService rs = (RenditionService)Framework.getLocalService(RenditionService.class);
        for (RenditionDefinition rd : rs.getAvailableRenditionDefinitions(doc)) {
            if (!rd.isVisible()) continue;
            result.add(rd);
        }
        return result;
    }

    public List<Rendition> getVisibleRenditions(String excludedKinds) {
        ArrayList<Rendition> availableRenditions;
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        RenditionService rs = (RenditionService)Framework.getLocalService(RenditionService.class);
        ArrayList<Rendition> filteredRenditions = availableRenditions = rs.getAvailableRenditions(doc, true);
        if (StringUtils.isNotBlank((String)excludedKinds)) {
            filteredRenditions = new ArrayList<Rendition>();
            List<String> excludedKindList = Arrays.asList(excludedKinds.split(","));
            for (Rendition rendition : availableRenditions) {
                if (excludedKindList.contains(rendition.getKind())) continue;
                filteredRenditions.add(rendition);
            }
        }
        return filteredRenditions;
    }

    public boolean hasVisibleRenditions(String excludedKinds) {
        return !this.getVisibleRenditions(excludedKinds).isEmpty();
    }

    public String getRenditionURL(String renditionName) {
        return this.getRenditionURL(this.navigationContext.getCurrentDocument(), renditionName);
    }

    public String getRenditionURL(DocumentModel doc, String renditionName) {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        return String.format(RENDITION_REST_URL_FORMAT, BaseURL.getBaseURL((ServletRequest)request), doc.getId(), renditionName);
    }
}

