/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Personality<T> {
    private Map<Class<? extends T>, Implementation> types = CollectionFactory.createHashedMap();

    public Personality() {
    }

    public Personality(Personality<T> other) {
        this();
        this.add(other);
    }

    public <X extends T> Personality<T> add(Class<X> interf, Implementation impl) {
        this.types.put(interf, impl);
        return this;
    }

    public Personality<T> copy() {
        return new Personality<T>(this);
    }

    public <X extends T> Implementation getImplementation(Class<X> t) {
        return this.types.get(t);
    }

    public Personality<T> add(Personality<T> p) {
        this.types.putAll(p.types);
        return this;
    }

    public <X extends T> X newInstance(Class<X> interf, Node n, EnhGraph that) {
        Implementation impl = this.types.get(interf);
        if (impl == null) {
            throw new PersonalityConfigException(interf + " not in Personality.");
        }
        EnhNode result = impl.wrap(n, that);
        if (!interf.isInstance(result)) {
            throw new PersonalityConfigException(interf + " misconfigured.");
        }
        return interf.cast(result);
    }

    protected Map<Class<? extends T>, Implementation> getMap() {
        return this.types;
    }
}

