/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.CmisBrowserBindingServlet;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisErrorHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoCmisBrowserBindingServlet
extends CmisBrowserBindingServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NuxeoCmisBrowserBindingServlet.class);
    public static final NuxeoBrowserServiceCall CALL = new NuxeoBrowserServiceCall();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)request);
        if (baseUrl != null) {
            baseUrl = StringUtils.stripEnd((String)baseUrl, (String)"/") + request.getServletPath() + "/" + "{repositoryId}" + "/";
            request.setAttribute("org.apache.chemistry.opencmis.baseurl", (Object)baseUrl);
        }
        super.service(request, response);
    }

    protected NuxeoCmisErrorHelper.ErrorInfo extractError(Exception ex) {
        return NuxeoCmisErrorHelper.extractError(ex);
    }

    public void printError(CallContext context, Exception ex, HttpServletRequest request, HttpServletResponse response) {
        String token;
        NuxeoCmisErrorHelper.ErrorInfo errorInfo = this.extractError(ex);
        if (response.isCommitted()) {
            LOG.warn("Failed to send error message to client. Response is already committed.", (Throwable)ex);
            return;
        }
        String string = token = context instanceof BrowserCallContextImpl ? ((BrowserCallContextImpl)context).getToken() : null;
        if (token == null) {
            response.resetBuffer();
            CALL.setStatus(request, response, errorInfo.statusCode);
            String message = ex.getMessage();
            if (!(ex instanceof CmisBaseException)) {
                message = "An error occurred!";
            }
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("exception", (Object)errorInfo.exceptionName);
            jsonResponse.put("message", (Object)errorInfo.message);
            String st = ExceptionHelper.getStacktraceAsString((Throwable)ex);
            if (st != null) {
                jsonResponse.put("stacktrace", (Object)st);
            }
            try {
                CALL.writeJSON((JSONStreamAware)jsonResponse, request, response);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    response.sendError(errorInfo.statusCode, message);
                }
                catch (IOException iOException) {}
            }
        } else {
            CALL.setStatus(request, response, 200);
            response.setContentType("text/html");
            response.setContentLength(0);
            if (context != null) {
                CALL.setCookie(request, response, context.getRepositoryId(), token, CALL.createCookieValue(errorInfo.statusCode, null, errorInfo.exceptionName, ex.getMessage()));
            }
        }
    }

    public static class NuxeoBrowserServiceCall
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        }
    }
}

