/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.config.ElasticSearchDocWriterDescriptor;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchLocalConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.core.ElasticSearchIndexingImpl;
import org.nuxeo.elasticsearch.core.ElasticSearchServiceImpl;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.work.IndexingWorker;
import org.nuxeo.elasticsearch.work.ScrollingIndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchComponent
extends DefaultComponent
implements ElasticSearchAdmin,
ElasticSearchIndexing,
ElasticSearchService {
    private static final Log log = LogFactory.getLog(ElasticSearchComponent.class);
    private static final String EP_REMOTE = "elasticSearchRemote";
    private static final String EP_LOCAL = "elasticSearchLocal";
    private static final String EP_INDEX = "elasticSearchIndex";
    private static final String EP_DOC_WRITER = "elasticSearchDocWriter";
    private static final long REINDEX_TIMEOUT = 20L;
    private final List<IndexingCommand> stackedCommands = Collections.synchronizedList(new ArrayList());
    private final Map<String, ElasticSearchIndexConfig> indexConfig = new HashMap<String, ElasticSearchIndexConfig>();
    private ElasticSearchLocalConfig localConfig;
    private ElasticSearchRemoteConfig remoteConfig;
    private ElasticSearchAdminImpl esa;
    private ElasticSearchIndexingImpl esi;
    private ElasticSearchServiceImpl ess;
    protected JsonESDocumentWriter jsonESDocumentWriter;
    private ListeningExecutorService waiterExecutorService;
    private final AtomicInteger runIndexingWorkerCount = new AtomicInteger(0);

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "elasticSearchLocal": {
                ElasticSearchLocalConfig localContrib = (ElasticSearchLocalConfig)contribution;
                if (localContrib.isEnabled()) {
                    this.localConfig = localContrib;
                    this.remoteConfig = null;
                    log.info((Object)("Registering local embedded configuration: " + this.localConfig + ", loaded from " + contributor.getName()));
                    break;
                }
                if (this.localConfig == null) break;
                log.info((Object)("Disabling previous local embedded configuration, deactivated by " + contributor.getName()));
                this.localConfig = null;
                break;
            }
            case "elasticSearchRemote": {
                ElasticSearchRemoteConfig remoteContribution = (ElasticSearchRemoteConfig)contribution;
                if (remoteContribution.isEnabled()) {
                    this.remoteConfig = remoteContribution;
                    this.localConfig = null;
                    log.info((Object)("Registering remote configuration: " + this.remoteConfig + ", loaded from " + contributor.getName()));
                    break;
                }
                if (this.remoteConfig == null) break;
                log.info((Object)("Disabling previous remote configuration, deactivated by " + contributor.getName()));
                this.remoteConfig = null;
                break;
            }
            case "elasticSearchIndex": {
                ElasticSearchIndexConfig idx = (ElasticSearchIndexConfig)contribution;
                ElasticSearchIndexConfig previous = this.indexConfig.get(idx.getName());
                if (idx.isEnabled()) {
                    idx.merge(previous);
                    this.indexConfig.put(idx.getName(), idx);
                    log.info((Object)("Registering index configuration: " + idx + ", loaded from " + contributor.getName()));
                    break;
                }
                if (previous == null) break;
                log.info((Object)("Disabling index configuration: " + previous + ", deactivated by " + contributor.getName()));
                this.indexConfig.remove(idx.getName());
                break;
            }
            case "elasticSearchDocWriter": {
                ElasticSearchDocWriterDescriptor writerDescriptor = (ElasticSearchDocWriterDescriptor)contribution;
                try {
                    this.jsonESDocumentWriter = writerDescriptor.getKlass().newInstance();
                    break;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.error((Object)("Can not instantiate jsonESDocumentWriter from " + writerDescriptor.getKlass()));
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("Invalid EP: " + extensionPoint);
            }
        }
    }

    public void applicationStarted(ComponentContext context) {
        if (!this.isElasticsearchEnabled()) {
            log.info((Object)"Elasticsearch service is disabled");
            return;
        }
        this.esa = new ElasticSearchAdminImpl(this.localConfig, this.remoteConfig, this.indexConfig);
        this.esi = new ElasticSearchIndexingImpl(this.esa, this.jsonESDocumentWriter);
        this.ess = new ElasticSearchServiceImpl(this.esa);
        this.initListenerThreadPool();
        this.processStackedCommands();
        this.reindexOnStartup();
    }

    private void reindexOnStartup() {
        boolean reindexOnStartup = Boolean.parseBoolean(Framework.getProperty((String)"elastcisearch.reindex.onStartup", (String)"false"));
        if (!reindexOnStartup) {
            return;
        }
        for (String repositoryName : this.esa.getInitializedRepositories()) {
            log.warn((Object)String.format("Indexing repository: %s on startup", repositoryName));
            this.runReindexingWorker(repositoryName, "SELECT ecm:uuid FROM Document");
            try {
                this.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TimeoutException e) {
                log.warn((Object)String.format("Indexation of repository %s not finised after %d s, continuing in background", repositoryName, 20L));
            }
        }
    }

    protected boolean isElasticsearchEnabled() {
        return Boolean.parseBoolean(Framework.getProperty((String)"elasticsearch.enabled", (String)"true"));
    }

    public void deactivate(ComponentContext context) {
        if (this.esa != null) {
            this.esa.disconnect();
        }
    }

    public int getApplicationStartedOrder() {
        RepositoryService component = (RepositoryService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        return component.getApplicationStartedOrder() / 2;
    }

    void processStackedCommands() {
        if (!this.stackedCommands.isEmpty()) {
            log.info((Object)String.format("Processing %d indexing commands stacked during startup", this.stackedCommands.size()));
            this.runIndexingWorker(this.stackedCommands);
            this.stackedCommands.clear();
            log.debug((Object)"Done");
        }
    }

    @Override
    public Client getClient() {
        return this.esa.getClient();
    }

    @Override
    public void initIndexes(boolean dropIfExists) {
        this.esa.initIndexes(dropIfExists);
    }

    @Override
    public void dropAndInitIndex(String indexName) {
        this.esa.dropAndInitIndex(indexName);
    }

    @Override
    public void dropAndInitRepositoryIndex(String repositoryName) {
        this.esa.dropAndInitRepositoryIndex(repositoryName);
    }

    @Override
    public List<String> getRepositoryNames() {
        return this.esa.getRepositoryNames();
    }

    @Override
    public String getIndexNameForRepository(String repositoryName) {
        return this.esa.getIndexNameForRepository(repositoryName);
    }

    @Override
    public List<String> getIndexNamesForType(String type) {
        return this.esa.getIndexNamesForType(type);
    }

    @Override
    public String getIndexNameForType(String type) {
        return this.esa.getIndexNameForType(type);
    }

    @Override
    public int getPendingWorkerCount() {
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        return wm.getQueueSize("elasticSearchIndexing", Work.State.SCHEDULED);
    }

    @Override
    public int getRunningWorkerCount() {
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        return this.runIndexingWorkerCount.get() + wm.getQueueSize("elasticSearchIndexing", Work.State.RUNNING);
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.esa.getTotalCommandProcessed();
    }

    @Override
    public boolean isEmbedded() {
        return this.esa.isEmbedded();
    }

    @Override
    public boolean isIndexingInProgress() {
        return this.runIndexingWorkerCount.get() > 0 || this.getPendingWorkerCount() > 0 || this.getRunningWorkerCount() > 0;
    }

    @Override
    public ListenableFuture<Boolean> prepareWaitForIndexing() {
        return this.waiterExecutorService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
                boolean completed = false;
                while (!(completed = wm.awaitCompletion("elasticSearchIndexing", 300L, TimeUnit.SECONDS))) {
                }
                return true;
            }
        });
    }

    protected void initListenerThreadPool() {
        this.waiterExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new NamedThreadFactory()));
    }

    @Override
    public void refresh() {
        this.esa.refresh();
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        this.esa.refreshRepositoryIndex(repositoryName);
    }

    @Override
    public void flush() {
        this.esa.flush();
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        this.esa.flushRepositoryIndex(repositoryName);
    }

    @Override
    public void optimize() {
        this.esa.optimize();
    }

    @Override
    public void optimizeRepositoryIndex(String repositoryName) {
        this.esa.optimizeRepositoryIndex(repositoryName);
    }

    @Override
    public void optimizeIndex(String indexName) {
        this.esa.optimizeIndex(indexName);
    }

    @Override
    public void indexNonRecursive(IndexingCommand cmd) {
        ArrayList<IndexingCommand> cmds = new ArrayList<IndexingCommand>(1);
        cmds.add(cmd);
        this.indexNonRecursive(cmds);
    }

    @Override
    public void indexNonRecursive(List<IndexingCommand> cmds) {
        if (!this.isReady()) {
            this.stackCommands(cmds);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process indexing commands: " + Arrays.toString(cmds.toArray())));
        }
        this.esi.indexNonRecursive(cmds);
    }

    protected void stackCommands(List<IndexingCommand> cmds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delaying indexing commands: Waiting for Index to be initialized." + Arrays.toString(cmds.toArray())));
        }
        this.stackedCommands.addAll(cmds);
    }

    @Override
    public void runIndexingWorker(List<IndexingCommand> cmds) {
        if (!this.isReady()) {
            this.stackCommands(cmds);
            return;
        }
        this.runIndexingWorkerCount.incrementAndGet();
        try {
            this.dispatchWork(cmds);
        }
        finally {
            this.runIndexingWorkerCount.decrementAndGet();
        }
    }

    protected void dispatchWork(List<IndexingCommand> cmds) {
        HashMap<String, List<IndexingCommand>> syncCommands = new HashMap<String, List<IndexingCommand>>();
        HashMap<String, List<IndexingCommand>> asyncCommands = new HashMap<String, List<IndexingCommand>>();
        for (IndexingCommand cmd : cmds) {
            if (cmd.isSync()) {
                ArrayList<IndexingCommand> syncCmds = (ArrayList<IndexingCommand>)syncCommands.get(cmd.getRepositoryName());
                if (syncCmds == null) {
                    syncCmds = new ArrayList<IndexingCommand>();
                }
                syncCmds.add(cmd);
                syncCommands.put(cmd.getRepositoryName(), syncCmds);
                continue;
            }
            ArrayList<IndexingCommand> asyncCmds = (ArrayList<IndexingCommand>)asyncCommands.get(cmd.getRepositoryName());
            if (asyncCmds == null) {
                asyncCmds = new ArrayList<IndexingCommand>();
            }
            asyncCmds.add(cmd);
            asyncCommands.put(cmd.getRepositoryName(), asyncCmds);
        }
        this.runIndexingSyncWorker(syncCommands);
        this.scheduleIndexingAsyncWorker(asyncCommands);
    }

    protected void scheduleIndexingAsyncWorker(Map<String, List<IndexingCommand>> asyncCommands) {
        if (asyncCommands.isEmpty()) {
            return;
        }
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        for (String repositoryName : asyncCommands.keySet()) {
            IndexingWorker idxWork = new IndexingWorker(repositoryName, asyncCommands.get(repositoryName));
            wm.schedule((Work)idxWork, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runIndexingSyncWorker(Map<String, List<IndexingCommand>> syncCommands) {
        if (syncCommands.isEmpty()) {
            return;
        }
        Transaction transaction = TransactionHelper.suspendTransaction();
        try {
            for (String repositoryName : syncCommands.keySet()) {
                IndexingWorker idxWork = new IndexingWorker(repositoryName, syncCommands.get(repositoryName));
                idxWork.run();
            }
        }
        finally {
            if (transaction != null) {
                TransactionHelper.resumeTransaction((Transaction)transaction);
            }
        }
    }

    @Override
    public void runReindexingWorker(String repositoryName, String nxql) {
        if (nxql == null || nxql.isEmpty()) {
            throw new IllegalArgumentException("Expecting an NXQL query");
        }
        ScrollingIndexingWorker worker = new ScrollingIndexingWorker(repositoryName, nxql);
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        wm.schedule((Work)worker);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) {
        return this.ess.query(queryBuilder);
    }

    @Override
    public EsResult queryAndAggregate(NxQueryBuilder queryBuilder) {
        return this.ess.queryAndAggregate(queryBuilder);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    private boolean isReady() {
        return this.esa != null && this.esa.isReady();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "waitForEsIndexing");
        }
    }
}

