/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.usermanager;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

@Deprecated
@Provider
@Consumes(value={"application/json+nxentity", "application/json"})
public class NuxeoPrincipalReader
implements MessageBodyReader<NuxeoPrincipal> {
    protected static final Log log = LogFactory.getLog(NuxeoPrincipalReader.class);
    @Context
    JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return NuxeoPrincipal.class.isAssignableFrom(type);
    }

    public NuxeoPrincipal readFrom(Class<NuxeoPrincipal> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        return this.readRequest(content, httpHeaders);
    }

    private NuxeoPrincipal readRequest(String content, MultivaluedMap<String, String> httpHeaders) {
        try {
            JsonParser jp = this.factory.createJsonParser(content);
            return NuxeoPrincipalReader.readJson(jp, httpHeaders);
        }
        catch (IOException | NuxeoException e) {
            throw new WebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    static NuxeoPrincipal readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders) throws JsonParseException, IOException {
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        String id = null;
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        DocumentModel userDoc = null;
        String schema = um.getUserSchemaName();
        while (tok != JsonToken.END_OBJECT) {
            String entityType;
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(key)) {
                id = (String)jp.readValueAs(String.class);
                NuxeoPrincipal principal = um.getPrincipal(id);
                userDoc = principal == null ? um.getBareUserModel() : principal.getModel();
            } else if ("extendedGroups".equals(key)) {
                jp.readValueAsTree();
            } else if ("properties".equals(key)) {
                NuxeoPrincipalReader.readProperties(jp, userDoc, schema);
            } else if ("entity-type".equals(key) && !"user".equals(entityType = (String)jp.readValueAs(String.class))) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            tok = jp.nextToken();
        }
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl(id);
        principal.setModel(userDoc);
        return principal;
    }

    protected static void readProperties(JsonParser jp, DocumentModel doc, String schemaName) throws PropertyException, JsonParseException, IOException {
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = schemaName + ":" + jp.getCurrentName();
            tok = jp.nextToken();
            if (tok == JsonToken.START_ARRAY) {
                doc.setPropertyValue(key, (Serializable)((Object)NuxeoPrincipalReader.readArrayProperty(jp)));
            } else if (tok == JsonToken.VALUE_NULL) {
                doc.setPropertyValue(key, (Serializable)((Object)((String)null)));
            } else {
                doc.setPropertyValue(key, (Serializable)((Object)jp.getText()));
            }
            tok = jp.nextToken();
        }
    }

    protected static List<Serializable> readArrayProperty(JsonParser jp) throws JsonParseException, IOException {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            if (tok == JsonToken.START_ARRAY) {
                list.add((Serializable)((Object)NuxeoPrincipalReader.readArrayProperty(jp)));
            } else {
                list.add((Serializable)((Object)jp.getText()));
            }
            tok = jp.nextToken();
        }
        return list;
    }
}

