/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoGroupJsonWriter
extends ExtensibleEntityJsonWriter<NuxeoGroup> {
    public static final String ENTITY_TYPE = "group";

    public NuxeoGroupJsonWriter() {
        super(ENTITY_TYPE, NuxeoGroup.class);
    }

    protected void writeEntityBody(NuxeoGroup group, JsonGenerator jg) throws IOException {
        jg.writeStringField("groupname", group.getName());
        jg.writeStringField("grouplabel", group.getLabel());
        if (this.ctx.getFetched(ENTITY_TYPE).contains("memberUsers")) {
            jg.writeArrayFieldStart("memberUsers");
            for (String user : group.getMemberUsers()) {
                jg.writeString(user);
            }
            jg.writeEndArray();
        }
        if (this.ctx.getFetched(ENTITY_TYPE).contains("memberGroups")) {
            jg.writeArrayFieldStart("memberGroups");
            for (String user : group.getMemberGroups()) {
                jg.writeString(user);
            }
            jg.writeEndArray();
        }
    }
}

