/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.impl.NuxeoGroupImpl;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoGroupJsonReader
extends EntityJsonReader<NuxeoGroup> {
    @Inject
    private UserManager userManager;

    public NuxeoGroupJsonReader() {
        super("group");
    }

    protected NuxeoGroup readEntity(JsonNode jn) throws IOException {
        NuxeoGroup group = null;
        String id = this.getStringField(jn, "groupname");
        if (id != null) {
            group = this.userManager.getGroup(id);
        }
        if (group == null) {
            group = new NuxeoGroupImpl(id);
        }
        String label = this.getStringField(jn, "grouplabel");
        group.setLabel(label);
        List<String> users = this.getArrayStringValues(jn.get("memberUsers"));
        group.setMemberUsers(users);
        List<String> groups = this.getArrayStringValues(jn.get("memberGroups"));
        group.setMemberGroups(groups);
        return group;
    }

    private List<String> getArrayStringValues(JsonNode node) {
        ArrayList<String> values = new ArrayList<String>();
        if (node != null && !node.isNull() && node.isArray()) {
            JsonNode elNode = null;
            Iterator it = node.getElements();
            while (it.hasNext()) {
                elNode = (JsonNode)it.next();
                if (elNode == null || elNode.isNull() || !elNode.isTextual()) continue;
                values.add(elNode.getTextValue());
            }
        }
        return values;
    }
}

