/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.model.Document;

public class GridFSBinaryManager
extends AbstractBinaryManager
implements BlobProvider {
    public static final String SERVER_PROPERTY = "server";
    public static final String DBNAME_PROPERTY = "dbname";
    public static final String BUCKET_PROPERTY = "bucket";
    protected Map<String, String> properties;
    protected MongoClient client;
    protected GridFS gridFS;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.properties = properties;
        String server = properties.get(SERVER_PROPERTY);
        if (StringUtils.isBlank((String)server)) {
            throw new NuxeoException("Missing server property in GridFS Binary Manager descriptor: " + blobProviderId);
        }
        String dbname = properties.get(DBNAME_PROPERTY);
        if (StringUtils.isBlank((String)dbname)) {
            throw new NuxeoException("Missing dbname property in GridFS Binary Manager descriptor: " + blobProviderId);
        }
        String bucket = properties.get(BUCKET_PROPERTY);
        if (StringUtils.isBlank((String)bucket)) {
            bucket = blobProviderId + ".fs";
        }
        this.client = server.startsWith("mongodb://") ? new MongoClient(new MongoClientURI(server)) : new MongoClient(new ServerAddress(server));
        this.gridFS = new GridFS(this.client.getDB(dbname), bucket);
        this.garbageCollector = new GridFSBinaryGarbageCollector();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public BinaryManager getBinaryManager() {
        return this;
    }

    public GridFS getGridFS() {
        return this.gridFS;
    }

    public Binary getBinary(Blob blob) throws IOException {
        String digest;
        if (!(blob instanceof FileBlob)) {
            return super.getBinary(blob);
        }
        File file = ((FileBlob)blob).getFile();
        long length = file.length();
        try (FileInputStream in = new FileInputStream(file);){
            digest = DigestUtils.md5Hex((InputStream)in);
        }
        GridFSDBFile dbFile = this.gridFS.findOne(digest);
        if (dbFile == null) {
            try (FileInputStream in = new FileInputStream(file);){
                GridFSInputFile inputFile = this.gridFS.createFile((InputStream)in, digest);
                inputFile.save();
            }
        }
        return new GridFSBinary(digest, length, this.blobProviderId);
    }

    protected Binary getBinary(InputStream in) throws IOException {
        GridFSInputFile inputFile = this.gridFS.createFile(in, true);
        inputFile.save();
        long length = inputFile.getLength();
        String digest = inputFile.getMD5();
        GridFSDBFile dbFile = this.gridFS.findOne(digest);
        if (dbFile == null) {
            inputFile.setFilename(digest);
            inputFile.save();
        } else {
            this.gridFS.remove((DBObject)inputFile);
        }
        return new GridFSBinary(digest, length, this.blobProviderId);
    }

    public Binary getBinary(String digest) {
        GridFSDBFile dbFile = this.gridFS.findOne(digest);
        if (dbFile != null) {
            return new GridFSBinary(digest, dbFile.getLength(), this.blobProviderId);
        }
        return null;
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).readBlob(blobInfo);
    }

    public String writeBlob(Blob blob, Document doc) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).writeBlob(blob, doc);
    }

    public boolean supportsUserUpdate() {
        return !Boolean.parseBoolean(this.properties.get("preventUserUpdate"));
    }

    public class GridFSBinaryGarbageCollector
    implements BinaryGarbageCollector {
        protected BinaryManagerStatus status;
        protected volatile long startTime;
        protected static final String MARK_KEY_PREFIX = "gc-mark-key-";
        protected String msKey;

        public String getId() {
            return "gridfs:" + GridFSBinaryManager.this.getGridFS().getBucketName();
        }

        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        public void mark(String digest) {
            GridFSDBFile dbFile = GridFSBinaryManager.this.gridFS.findOne(digest);
            if (dbFile != null) {
                dbFile.setMetaData((DBObject)new BasicDBObject(this.msKey, (Object)Boolean.TRUE));
                dbFile.save();
                ++this.status.numBinaries;
                this.status.sizeBinaries += dbFile.getLength();
            }
        }

        public void start() {
            if (this.startTime != 0L) {
                throw new NuxeoException("Already started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
            this.msKey = MARK_KEY_PREFIX + System.currentTimeMillis();
        }

        public void stop(boolean delete) {
            BasicDBObject query = new BasicDBObject("metadata." + this.msKey, (Object)new BasicDBObject("$exists", (Object)Boolean.FALSE));
            List files = GridFSBinaryManager.this.gridFS.find((DBObject)query);
            for (GridFSDBFile file : files) {
                ++this.status.numBinariesGC;
                this.status.sizeBinariesGC += file.getLength();
                if (!delete) continue;
                GridFSBinaryManager.this.gridFS.remove((DBObject)file);
            }
            this.startTime = 0L;
        }
    }

    protected class GridFSBinary
    extends Binary {
        private static final long serialVersionUID = 1L;

        protected GridFSBinary(String digest, long length, String blobProviderId) {
            super(digest, blobProviderId);
            this.length = length;
        }

        public InputStream getStream() {
            GridFSDBFile dbFile = GridFSBinaryManager.this.gridFS.findOne(this.digest);
            return dbFile == null ? null : dbFile.getInputStream();
        }
    }
}

