/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;

public class DBSRepositoryDescriptor
implements Cloneable {
    @XNode(value="@name")
    public String name;
    @XNode(value="@label")
    public String label;
    @XNode(value="@isDefault")
    protected Boolean isDefault;
    protected FulltextDescriptor fulltextDescriptor = new FulltextDescriptor();

    public Boolean isDefault() {
        return this.isDefault;
    }

    public FulltextDescriptor getFulltextDescriptor() {
        return this.fulltextDescriptor;
    }

    @XNode(value="fulltext@disabled")
    public void setFulltextDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextDisabled(disabled);
    }

    @XNode(value="fulltext@searchDisabled")
    public void setFulltextSearchDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextSearchDisabled(disabled);
    }

    @XNode(value="fulltext@parser")
    public void setFulltextParser(String fulltextParser) {
        this.fulltextDescriptor.setFulltextParser(fulltextParser);
    }

    @XNodeList(value="fulltext/index", type=ArrayList.class, componentType=FulltextDescriptor.FulltextIndexDescriptor.class)
    public void setFulltextIndexes(List<FulltextDescriptor.FulltextIndexDescriptor> fulltextIndexes) {
        this.fulltextDescriptor.setFulltextIndexes(fulltextIndexes);
    }

    @XNodeList(value="fulltext/excludedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextExcludedTypes(Set<String> fulltextExcludedTypes) {
        this.fulltextDescriptor.setFulltextExcludedTypes(fulltextExcludedTypes);
    }

    @XNodeList(value="fulltext/includedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextIncludedTypes(Set<String> fulltextIncludedTypes) {
        this.fulltextDescriptor.setFulltextIncludedTypes(fulltextIncludedTypes);
    }

    public DBSRepositoryDescriptor clone() {
        try {
            DBSRepositoryDescriptor clone = (DBSRepositoryDescriptor)super.clone();
            clone.fulltextDescriptor = new FulltextDescriptor(this.fulltextDescriptor);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(DBSRepositoryDescriptor other) {
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.isDefault != null) {
            this.isDefault = other.isDefault;
        }
        this.fulltextDescriptor.merge(other.fulltextDescriptor);
    }
}

