/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="queue")
public class WorkQueueDescriptor {
    public static final String ALL_QUEUES = "*";
    public static final int DEFAULT_MAX_THREADS = 4;
    public static final int DEFAULT_CLEAR_COMPLETED_AFTER_SECONDS = 600;
    public static final int DEFAULT_CAPACITY = -1;
    @XNode(value="@id")
    public String id;
    @XNode(value="@queueing")
    public Boolean queuing;
    @XNode(value="@processing")
    public Boolean processing;
    @XNode(value="name")
    public String name;
    @XNode(value="maxThreads")
    public Integer maxThreads;
    @XNode(value="clearCompletedAfterSeconds")
    public Integer clearCompletedAfterSeconds;
    @XNodeList(value="category", type=HashSet.class, componentType=String.class)
    public Set<String> categories = Collections.emptySet();
    @XNode(value="capacity")
    public Integer capacity;

    public boolean isQueuingEnabled() {
        return !Boolean.FALSE.equals(this.queuing);
    }

    public boolean isProcessingEnabled() {
        return !Boolean.FALSE.equals(this.processing);
    }

    public int getMaxThreads() {
        return this.maxThreads == null ? 4 : this.maxThreads;
    }

    public int getClearCompletedAfterSeconds() {
        return this.clearCompletedAfterSeconds == null ? 600 : this.clearCompletedAfterSeconds;
    }

    public int getCapacity() {
        return this.capacity == null ? -1 : this.capacity;
    }

    public WorkQueueDescriptor clone() {
        WorkQueueDescriptor o = new WorkQueueDescriptor();
        o.id = this.id;
        o.queuing = this.queuing;
        o.processing = this.processing;
        o.name = this.name;
        o.maxThreads = this.maxThreads;
        o.clearCompletedAfterSeconds = this.clearCompletedAfterSeconds;
        o.capacity = this.capacity;
        o.categories = new HashSet<String>(this.categories);
        return o;
    }

    public void merge(WorkQueueDescriptor other) {
        if (other.queuing != null) {
            this.queuing = other.queuing;
        }
        if (other.processing != null) {
            this.processing = other.processing;
        }
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.maxThreads != null) {
            this.maxThreads = other.maxThreads;
        }
        if (other.clearCompletedAfterSeconds != null) {
            this.clearCompletedAfterSeconds = other.clearCompletedAfterSeconds;
        }
        if (other.capacity != null) {
            this.capacity = other.capacity;
        }
        this.categories.addAll(other.categories);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append("[id=");
        buf.append(this.id);
        buf.append(" categories=");
        buf.append(this.categories);
        if (this.queuing != null) {
            buf.append(" queuing=");
            buf.append(this.queuing);
        }
        if (this.processing != null) {
            buf.append(" processing=");
            buf.append(this.processing);
        }
        if (this.maxThreads != null) {
            buf.append(" maxThreads=");
            buf.append(this.maxThreads);
        }
        if (this.capacity != null) {
            buf.append(" capacity=");
            buf.append(this.capacity);
        }
        if (this.clearCompletedAfterSeconds != null) {
            buf.append(" clearCompletedAfterSeconds=");
            buf.append(this.clearCompletedAfterSeconds);
        }
        buf.append("]");
        return buf.toString();
    }

    public String toEffectiveString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append("(id=");
        buf.append(this.id);
        buf.append(" categories=");
        buf.append(this.categories);
        buf.append(" queuing=");
        buf.append(this.isQueuingEnabled());
        buf.append(" processing=");
        buf.append(this.isProcessingEnabled());
        buf.append(" maxThreads=");
        buf.append(this.getMaxThreads());
        buf.append(" capacity=");
        buf.append(this.getCapacity());
        buf.append(" clearCompletedAfterSeconds=");
        buf.append(this.getClearCompletedAfterSeconds());
        buf.append(")");
        return buf.toString();
    }
}

