/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;

public class ShallowEvent
extends EventImpl {
    private static final long serialVersionUID = 1L;

    public static ShallowEvent create(Event event) {
        DocumentModel oldDoc;
        EventContext ctx = event.getContext();
        ArrayList<Object> newArgs = new ArrayList<Object>();
        Object[] objectArray = ctx.getArguments();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object arg;
            Object newArg = arg = objectArray[i];
            if (arg instanceof DocumentModel) {
                oldDoc = (DocumentModel)arg;
                DocumentRef ref = oldDoc.getRef();
                newArg = ref != null ? new ShallowDocumentModel(oldDoc) : null;
            }
            newArgs.add(newArg);
        }
        EventContextImpl newCtx = null;
        if (ctx instanceof DocumentEventContext) {
            newCtx = new DocumentEventContext(null, ctx.getPrincipal(), (DocumentModel)newArgs.get(0), (DocumentRef)newArgs.get(1));
        } else {
            newCtx = new EventContextImpl(null, ctx.getPrincipal());
            newCtx.setArgs(newArgs.toArray());
        }
        newCtx.setRepositoryName(ctx.getRepositoryName());
        HashMap<String, Serializable> newProps = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> prop : ctx.getProperties().entrySet()) {
            Object propValue = prop.getValue();
            if (propValue instanceof DocumentModel) {
                oldDoc = (DocumentModel)propValue;
                propValue = new ShallowDocumentModel(oldDoc);
            }
            newProps.put(prop.getKey(), (Serializable)propValue);
        }
        newCtx.setProperties(newProps);
        return new ShallowEvent(event.getName(), newCtx, event.getFlags(), event.getTime());
    }

    public ShallowEvent(String name, EventContext ctx, int flags, long creationTime) {
        super(name, ctx, flags, creationTime);
    }
}

