/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.context.DepthValues;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.context.WrappedContext;

public class RenderingContextImpl
implements RenderingContext {
    private String baseUrl = "http://fake-url.nuxeo.com/";
    private Locale locale = DEFAULT_LOCALE;
    private CoreSession session = null;
    private final Map<String, List<Object>> parameters = new ConcurrentHashMap<String, List<Object>>();

    private RenderingContextImpl() {
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public RenderingContext.SessionWrapper getSession(DocumentModel document) {
        if (document != null) {
            CoreSession docSession = null;
            try {
                docSession = document.getCoreSession();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (docSession != null) {
                return new RenderingContext.SessionWrapper(docSession, false);
            }
        }
        if (this.session != null) {
            return new RenderingContext.SessionWrapper(this.session, false);
        }
        String repoNameFound = (String)this.getParameter("X-NXRepository");
        if (org.apache.commons.lang.StringUtils.isBlank((String)repoNameFound) && org.apache.commons.lang.StringUtils.isBlank((String)(repoNameFound = (String)this.getParameter("nxrepository")))) {
            try {
                repoNameFound = document.getRepositoryName();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)repoNameFound)) {
            CoreSession session = CoreInstance.openCoreSession((String)repoNameFound);
            return new RenderingContext.SessionWrapper(session, true);
        }
        throw new MarshallingException("Unable to create a new session");
    }

    @Override
    public void setExistingSession(CoreSession session) {
        this.session = session;
    }

    @Override
    public Set<String> getProperties() {
        return this.getSplittedParameterValues("properties", new String[0]);
    }

    @Override
    public Set<String> getFetched(String entity) {
        return this.getSplittedParameterValues("fetch", entity);
    }

    @Override
    public Set<String> getTranslated(String entity) {
        return this.getSplittedParameterValues("translate", entity);
    }

    @Override
    public Set<String> getEnrichers(String entity) {
        return this.getSplittedParameterValues("enrichers", entity);
    }

    private Set<String> getSplittedParameterValues(String category, String ... subCategories) {
        Set<String> result = this.getSplittedParameterValues('.', category, subCategories);
        result.addAll(this.getSplittedParameterValues('-', category, subCategories));
        return result;
    }

    private Set<String> getSplittedParameterValues(char separator, String category, String ... subCategories) {
        if (category == null) {
            return Collections.emptySet();
        }
        String paramKey = category;
        for (String subCategory : subCategories) {
            paramKey = paramKey + separator + subCategory;
        }
        paramKey = paramKey.toLowerCase();
        List dirty = this.getParameters(paramKey);
        dirty.addAll(this.getParameters("X-NX" + paramKey));
        if ("properties".toLowerCase().equals(paramKey)) {
            dirty.addAll(this.getParameters("X-NXDocumentProperties"));
        } else if (("enrichers" + separator + "document").toLowerCase().equals(paramKey)) {
            dirty.addAll(this.getParameters("X-NXContext-Category"));
        }
        TreeSet<String> result = new TreeSet<String>();
        for (Object value : dirty) {
            if (!(value instanceof String) || value == null) continue;
            for (String cleaned : StringUtils.split((String)((String)value), (char)',', (boolean)true)) {
                result.add(cleaned);
            }
        }
        return result;
    }

    private <T> T getWrappedEntity(String name) {
        return WrappedContext.getEntity(this, name);
    }

    @Override
    public WrappedContext wrap() {
        return WrappedContext.create(this);
    }

    @Override
    public <T> T getParameter(String name) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)name)) {
            return null;
        }
        String realName = name.toLowerCase().trim();
        List<Object> values = this.parameters.get(realName);
        if (values != null && values.size() > 0) {
            Object value = values.get(0);
            return (T)value;
        }
        if ("_MarshalledEntitiesWrappedContext".toLowerCase().equals(realName)) {
            return null;
        }
        return this.getWrappedEntity(realName);
    }

    @Override
    public boolean getBooleanParameter(String name) {
        Object result = this.getParameter(name);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            try {
                return Boolean.valueOf((String)result);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public <T> List<T> getParameters(String name) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)name)) {
            return null;
        }
        String realName = name.toLowerCase().trim();
        List<Object> values = this.parameters.get(realName);
        if (values != null) {
            return new ArrayList<Object>(values);
        }
        return new ArrayList();
    }

    @Override
    public Map<String, List<Object>> getAllParameters() {
        HashMap<String, List<Object>> unModifiableParameters = new HashMap<String, List<Object>>();
        for (Map.Entry<String, List<Object>> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            List<Object> value = entry.getValue();
            if (value == null) {
                unModifiableParameters.put(key, null);
                continue;
            }
            unModifiableParameters.put(key, new ArrayList<Object>(value));
        }
        return unModifiableParameters;
    }

    @Override
    public void setParameterValues(String name, Object ... values) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)name)) {
            return;
        }
        String realName = name.toLowerCase().trim();
        if (values.length == 0) {
            this.parameters.remove(realName);
            return;
        }
        this.setParameterListValues(realName, Arrays.asList(values));
    }

    @Override
    public void setParameterListValues(String name, List<Object> values) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)name)) {
            return;
        }
        String realName = name.toLowerCase().trim();
        if (values == null) {
            this.parameters.remove(realName);
        }
        this.parameters.put(realName, new CopyOnWriteArrayList<Object>(values));
    }

    @Override
    public void addParameterValues(String name, Object ... values) {
        this.addParameterListValues(name, Arrays.asList(values));
    }

    @Override
    public void addParameterListValues(String name, List<Object> values) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)name)) {
            return;
        }
        String realName = name.toLowerCase().trim();
        if (values == null) {
            return;
        }
        List<Object> currentValues = this.parameters.get(realName);
        if (currentValues == null) {
            currentValues = new CopyOnWriteArrayList<Object>();
            this.parameters.put(realName, currentValues);
        }
        for (Object value : values) {
            currentValues.add(value);
        }
    }

    static RenderingContextBuilder builder() {
        return new RenderingContextBuilder();
    }

    public static final class RenderingContextBuilder {
        private RenderingContextImpl ctx = new RenderingContextImpl();

        RenderingContextBuilder() {
        }

        public RenderingContextBuilder base(String url) {
            this.ctx.baseUrl = url;
            return this;
        }

        public RenderingContextBuilder locale(Locale locale) {
            this.ctx.locale = locale;
            return this;
        }

        public RenderingContextBuilder session(CoreSession session) {
            this.ctx.session = session;
            return this;
        }

        public RenderingContextBuilder param(String name, Object value) {
            this.ctx.addParameterValues(name, value);
            return this;
        }

        public RenderingContextBuilder paramValues(String name, Object ... values) {
            this.ctx.addParameterValues(name, values);
            return this;
        }

        public RenderingContextBuilder paramList(String name, List<Object> values) {
            this.ctx.addParameterListValues(name, values);
            return this;
        }

        public RenderingContextBuilder properties(String ... schemaName) {
            return this.paramValues("properties", schemaName);
        }

        public RenderingContextBuilder enrich(String entityType, String ... enricherName) {
            return this.paramValues("enrichers-" + entityType, enricherName);
        }

        public RenderingContextBuilder enrichDoc(String ... enricherName) {
            return this.enrich("document", enricherName);
        }

        public RenderingContextBuilder fetch(String entityType, String ... propertyName) {
            return this.paramValues("fetch-" + entityType, propertyName);
        }

        public RenderingContextBuilder fetchInDoc(String ... propertyName) {
            return this.fetch("document", propertyName);
        }

        public RenderingContextBuilder translate(String entityType, String ... propertyName) {
            return this.paramValues("translate-" + entityType, propertyName);
        }

        public RenderingContextBuilder depth(DepthValues value) {
            this.ctx.setParameterValues("depth", value.name());
            return this;
        }

        public RenderingContext get() {
            return this.ctx;
        }
    }
}

