/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DownloadServlet.class);
    @Deprecated
    public static final String NXBIGFILE = "nxbigfile";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.handleDownload(req, resp);
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect((IOException)ioe);
        }
    }

    protected void handleDownload(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e) {
            requestURI = req.getRequestURI();
        }
        String context = VirtualHostHelper.getContextPath((ServletRequest)req) + "/";
        if (!requestURI.startsWith(context)) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String localURI = requestURI.substring(context.length());
        int slash = localURI.indexOf(47);
        if (slash < 0) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String what = localURI.substring(0, slash);
        String path = localURI.substring(slash + 1);
        switch (what) {
            case "nxfile": 
            case "nxbigfile": {
                this.downloadBlob(req, resp, path, false);
                break;
            }
            case "nxdownloadinfo": {
                this.downloadBlob(req, resp, path, true);
                break;
            }
            case "nxbigzipfile": {
                this.handleDownloadTemporaryZip(req, resp, path);
                break;
            }
            case "nxbigblob": {
                this.handleDownloadSessionBlob(req, resp, path);
                break;
            }
            default: {
                resp.sendError(404, "Invalid URL syntax");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void downloadBlob(HttpServletRequest req, HttpServletResponse resp, String urlPath, boolean info) throws IOException {
        String[] parts = urlPath.split("/");
        if (parts.length < 2) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String repositoryName = parts[0];
        String docId = parts[1];
        boolean tx = false;
        try {
            if (!TransactionHelper.isTransactionActive()) {
                tx = TransactionHelper.startTransaction();
            }
            try (CoreSession session = CoreInstance.openCoreSession((String)repositoryName);){
                IdRef docRef = new IdRef(docId);
                if (!session.exists((DocumentRef)docRef)) {
                    resp.sendError(404, "No Blob found");
                    return;
                }
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                Pair<String, String> pair = DownloadServlet.parsePath(urlPath);
                String xpath = (String)pair.getLeft();
                String filename = (String)pair.getRight();
                DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
                if (info) {
                    Blob blob = downloadService.resolveBlob(doc, xpath);
                    if (blob == null) {
                        resp.sendError(404, "No blob found");
                        return;
                    }
                    String downloadUrl = VirtualHostHelper.getBaseURL((ServletRequest)req) + downloadService.getDownloadUrl(doc, xpath, filename);
                    String result = blob.getMimeType() + ':' + URLEncoder.encode(blob.getFilename(), "UTF-8") + ':' + downloadUrl;
                    resp.setContentType("text/plain");
                    resp.getWriter().write(result);
                    resp.getWriter().flush();
                    return;
                }
                downloadService.downloadBlob(req, resp, doc, xpath, null, filename, "download");
                return;
            }
        }
        catch (NuxeoException e) {
            if (!tx) throw new IOException(e);
            TransactionHelper.setTransactionRollbackOnly();
            throw new IOException(e);
        }
        finally {
            if (tx) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    protected static Pair<String, String> parsePath(String urlPath) {
        String filename;
        String xpath;
        String[] parts = urlPath.split("/");
        int length = parts.length;
        if (length == 2) {
            xpath = "blobholder:0";
            filename = null;
        } else if (length == 3) {
            xpath = parts[2];
            filename = null;
        } else {
            xpath = StringUtils.join(Arrays.asList(parts).subList(2, length - 1), (String)"/");
            filename = parts[length - 1];
        }
        return Pair.of((Object)xpath, filename);
    }

    protected void handleDownloadSessionBlob(HttpServletRequest req, HttpServletResponse resp, String blobId) throws IOException {
        Blob blob = (Blob)req.getAttribute(blobId);
        if (blob != null) {
            req.removeAttribute(blobId);
        } else {
            HttpSession session = req.getSession(false);
            if (session == null) {
                log.error((Object)("Unable to download blob " + blobId + " since the holding http session does not exist"));
                return;
            }
            blob = (Blob)session.getAttribute(blobId);
            if (blob == null) {
                return;
            }
            session.removeAttribute(blobId);
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        downloadService.downloadBlob(req, resp, null, null, blob, null, "operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownloadTemporaryZip(HttpServletRequest req, HttpServletResponse resp, String filePath) throws IOException {
        String[] pathParts = filePath.split("/");
        String tmpFileName = pathParts[0];
        File tmpZip = new File(Environment.getDefault().getTemp(), tmpFileName);
        try {
            Blob zipBlob = Blobs.createBlob((File)tmpZip);
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            downloadService.downloadBlob(req, resp, null, null, zipBlob, "clipboard.zip", "clipboardZip");
        }
        finally {
            tmpZip.delete();
        }
    }
}

