/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperConnector;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperTxSuspender;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;

public class JDBCBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(JDBCBackend.class);
    private RepositoryImpl repository;
    private String pseudoDataSourceName;
    private XADataSource xadatasource;
    private Dialect dialect;
    private SQLInfo sqlInfo;
    private boolean firstMapper = true;
    private Boolean initialized;
    private ClusterInvalidator clusterInvalidator;
    private boolean isPooledDataSource;

    @Override
    public void initialize(RepositoryImpl repository) {
        Object instance;
        Class<?> klass;
        this.repository = repository;
        RepositoryDescriptor repositoryDescriptor = repository.getRepositoryDescriptor();
        this.pseudoDataSourceName = ConnectionHelper.getPseudoDataSourceNameForRepository((String)repositoryDescriptor.name);
        try {
            DataSource ds = DataSourceHelper.getDataSource((String)this.pseudoDataSourceName);
            if (ds instanceof PooledDataSourceRegistry.PooledDataSource) {
                this.isPooledDataSource = true;
                return;
            }
        }
        catch (NamingException ds) {
            // empty catch block
        }
        try (Connection connection = ConnectionHelper.getConnection((String)this.pseudoDataSourceName);){
            if (connection != null) {
                return;
            }
        }
        catch (SQLException cause) {
            throw new NuxeoException("Connection error", (Throwable)cause);
        }
        String className = repositoryDescriptor.xaDataSourceName;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NuxeoException("Unknown class: " + className, (Throwable)e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Cannot instantiate class: " + className, (Throwable)e);
        }
        if (!(instance instanceof XADataSource)) {
            throw new NuxeoException("Not a XADataSource: " + className);
        }
        this.xadatasource = (XADataSource)instance;
        for (Map.Entry<String, String> entry : repositoryDescriptor.properties.entrySet()) {
            String name = entry.getKey();
            String value = Framework.expandVars((String)entry.getValue());
            if (name.contains("/")) {
                name = name.substring(0, name.indexOf(47));
            }
            if (Character.isLowerCase(name.charAt(1))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            try {
                BeanUtils.setProperty((Object)this.xadatasource, (String)name, (Object)value);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)String.format("Cannot set %s = %s", name, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeModelSetup(ModelSetup modelSetup) {
        try {
            XAConnection xaconnection = null;
            Connection connection = ConnectionHelper.getConnection((String)this.pseudoDataSourceName);
            try {
                if (connection == null) {
                    xaconnection = this.xadatasource.getXAConnection();
                    connection = xaconnection.getConnection();
                }
                this.dialect = Dialect.createDialect(connection, this.repository.getRepositoryDescriptor());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (xaconnection != null) {
                    xaconnection.close();
                }
            }
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot connect to database", (Throwable)cause);
        }
        modelSetup.materializeFulltextSyntheticColumn = this.dialect.getMaterializeFulltextSyntheticColumn();
        modelSetup.supportsArrayColumns = this.dialect.supportsArrayColumns();
        switch (this.dialect.getIdType()) {
            case VARCHAR: 
            case UUID: {
                modelSetup.idType = Model.IdType.STRING;
                break;
            }
            case SEQUENCE: {
                modelSetup.idType = Model.IdType.LONG;
                break;
            }
            default: {
                throw new AssertionError((Object)this.dialect.getIdType().toString());
            }
        }
    }

    @Override
    public void initializeModel(Model model) {
        this.sqlInfo = new SQLInfo(model, this.dialect);
    }

    @Override
    public void setClusterInvalidator(ClusterInvalidator clusterInvalidator) {
        this.clusterInvalidator = clusterInvalidator;
    }

    @Override
    public Mapper newMapper(Model model, Session.PathResolver pathResolver, boolean useInvalidations) {
        boolean noSharing = !useInvalidations;
        RepositoryDescriptor repositoryDescriptor = this.repository.getRepositoryDescriptor();
        ClusterInvalidator cnh = useInvalidations ? this.clusterInvalidator : null;
        Mapper mapper = new JDBCMapper(model, pathResolver, this.sqlInfo, this.xadatasource, cnh, noSharing, this.repository);
        if (this.isPooledDataSource) {
            mapper = JDBCMapperConnector.newConnector(mapper);
            if (noSharing) {
                mapper = JDBCMapperTxSuspender.newConnector(mapper);
            }
        } else {
            mapper.connect();
        }
        String repositoryName = this.repository.getName();
        if (Boolean.FALSE.equals(this.initialized)) {
            throw new NuxeoException("Database initialization failed previously for: " + repositoryName);
        }
        if (this.firstMapper) {
            this.initialized = Boolean.FALSE;
            this.firstMapper = false;
            String ddlMode = repositoryDescriptor.getDDLMode();
            if (ddlMode == null) {
                String string = ddlMode = repositoryDescriptor.getNoDDL() ? "ignore" : "execute";
            }
            if (ddlMode.equals("ignore")) {
                log.info((Object)"Skipping database creation");
            } else {
                mapper.createDatabase(ddlMode);
            }
            if (log.isDebugEnabled()) {
                FulltextDescriptor fulltextDescriptor = repositoryDescriptor.getFulltextDescriptor();
                log.debug((Object)String.format("Database ready, fulltext: disabled=%b searchDisabled=%b.", fulltextDescriptor.getFulltextDisabled(), fulltextDescriptor.getFulltextSearchDisabled()));
            }
            this.initialized = Boolean.TRUE;
        }
        return mapper;
    }

    @Override
    public void shutdown() {
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.close();
        }
    }
}

