/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.jsf.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.Messages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="collectionActions")
@Scope(value=ScopeType.PAGE)
@BypassInterceptors
public class CollectionActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COLLECTION_CURRENT_SELECTION = "COLLECTION_CURRENT_SELECTION";
    public static final String DOCUMENT_ADDED_TO_COLLECTION_EVENT = "documentAddedToCollection";
    public static final String DOCUMENT_REMOVED_FROM_COLLECTION_EVENT = "documentRemovedFromCollection";
    private static final Log log = LogFactory.getLog(CollectionActionsBean.class);
    private List<String> docUidsToBeAdded;
    private String newDescription;
    private String newTitle;
    private DocumentModel selectedCollection;
    private String selectedCollectionUid;

    protected static void addFacesMessage(StatusMessage.Severity severity, String message, String arguments) {
        FacesMessages facesMessages = (FacesMessages)Component.getInstance((String)"facesMessages", (boolean)true);
        facesMessages.add(severity, (String)Messages.instance().get(message), new Object[]{Messages.instance().get(arguments)});
    }

    public void addCurrentDocumentToSelectedCollection() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            if (this.isCreateNewCollection()) {
                collectionManager.addToNewCollection(this.getNewTitle(), this.getNewDescription(), currentDocument, session);
            } else {
                collectionManager.addToCollection(this.getSelectedCollection(), currentDocument, session);
            }
            Events.instance().raiseEvent("documentChanged", new Object[0]);
            navigationContext.invalidateCurrentDocument();
            CollectionActionsBean.addFacesMessage(StatusMessage.Severity.INFO, "collection.addedToCollection", this.isCreateNewCollection() ? this.getNewTitle() : this.getSelectedCollection().getTitle());
        }
    }

    public void addCurrentSelectionToSelectedCollection() {
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        this.addToSelectedCollection(documentsListsManager.getWorkingList("CURRENT_SELECTION"));
    }

    public void addDocUidsToBeAddedToCurrentCollection() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        ArrayList<DocumentModel> documentListToBeAdded = new ArrayList<DocumentModel>(this.docUidsToBeAdded.size());
        for (String uid : this.docUidsToBeAdded) {
            documentListToBeAdded.add(session.getDocument((DocumentRef)new IdRef(uid)));
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        collectionManager.addToCollection(currentDocument, documentListToBeAdded, session);
        Events.instance().raiseEvent("documentChanged", new Object[0]);
        CollectionActionsBean.addFacesMessage(StatusMessage.Severity.INFO, "collection.allAddedToCollection", currentDocument.getTitle());
    }

    public void addToSelectedCollection(List<DocumentModel> documentListToBeAdded) {
        if (documentListToBeAdded != null && !documentListToBeAdded.isEmpty()) {
            CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            if (this.isCreateNewCollection()) {
                collectionManager.addToNewCollection(this.getNewTitle(), this.getNewDescription(), documentListToBeAdded, session);
            } else {
                collectionManager.addToCollection(this.getSelectedCollection(), documentListToBeAdded, session);
            }
            Events.instance().raiseEvent("documentChanged", new Object[0]);
            CollectionActionsBean.addFacesMessage(StatusMessage.Severity.INFO, "collection.allAddedToCollection", this.isCreateNewCollection() ? this.getNewTitle() : this.getSelectedCollection().getTitle());
        }
    }

    public boolean canAddSelectedDocumentBeCollected() {
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        List documents = documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (documents == null || documents.isEmpty()) {
            return false;
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        for (DocumentModel doc : documents) {
            if (collectionManager.isCollectable(doc)) continue;
            return false;
        }
        return true;
    }

    public boolean canAddToCollection(DocumentModel collection) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        boolean result = collection != null && collectionManager.isCollection(collection) && collectionManager.canAddToCollection(collection, session);
        return result;
    }

    public boolean canAddToDocsToCurrentCollection() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        return collectionManager.canAddToCollection(currentDocument, session);
    }

    public boolean canAddToSelectedCollection() {
        boolean result = this.canAddToCollection(this.getSelectedCollection()) || this.isCreateNewCollection();
        return result;
    }

    public void cancel() {
        this.selectedCollectionUid = null;
        this.newDescription = null;
        this.newTitle = null;
        this.docUidsToBeAdded = null;
    }

    public boolean canCurrentDocumentBeCollected() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        return collectionManager.isCollectable(currentDocument);
    }

    public boolean canManage(DocumentModel collection) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        return collectionManager.canManage(collection, session);
    }

    public boolean canRemoveFromCollection() {
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        List doccumentListToBeRemoved = documentsListsManager.getWorkingList(COLLECTION_CURRENT_SELECTION);
        if (doccumentListToBeRemoved == null || doccumentListToBeRemoved.isEmpty()) {
            return false;
        }
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        return this.canAddToCollection(currentDocument);
    }

    public boolean canRemoveFromCollection(DocumentModel collection) {
        return this.canAddToCollection(collection);
    }

    public List<String> getDocUidsToBeAdded() {
        return this.docUidsToBeAdded;
    }

    protected DocumentsListsManager getDocumentsListsManager() {
        return (DocumentsListsManager)Component.getInstance((String)"documentsListsManager", (boolean)true);
    }

    public List<DocumentModel> getMultipleDocumentToBeAdded() {
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        return documentsListsManager.getWorkingList("CURRENT_SELECTION");
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public String getNewTitle() {
        return this.newTitle;
    }

    public DocumentModel getSelectedCollection() {
        if (this.selectedCollection == null && StringUtils.isNotBlank((String)this.selectedCollectionUid) && !this.isCreateNewCollection()) {
            try {
                CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
                this.selectedCollection = session.getDocument((DocumentRef)new IdRef(this.selectedCollectionUid));
            }
            catch (DocumentNotFoundException e) {
                log.error((Object)"Cannot fetch collection");
            }
        }
        return this.selectedCollection;
    }

    public String getSelectedCollectionDescription() throws PropertyException {
        if (this.isCreateNewCollection()) {
            return null;
        }
        return (String)((Object)this.getSelectedCollection().getProperty("dc:description").getValue());
    }

    public String getSelectedCollectionUid() {
        return this.selectedCollectionUid;
    }

    public boolean hasCurrentDocumentVisibleCollection() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        return this.hasVisibleCollection(currentDocument);
    }

    public boolean hasVisibleCollection(DocumentModel doc) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        if (doc == null || !collectionManager.isCollectable(doc)) {
            return false;
        }
        if (collectionManager.isCollected(doc)) {
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            return collectionManager.hasVisibleCollection(doc, session);
        }
        return false;
    }

    public boolean isCreateNewCollection() {
        return this.selectedCollectionUid != null && this.selectedCollectionUid.startsWith("-999999");
    }

    public boolean isCurrentDocumentCollection() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        return collectionManager.isCollection(currentDocument);
    }

    public void removeCurrentDocumentFromCollection(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String collectionId = (String)eContext.getRequestParameterMap().get("collectionId");
        if (StringUtils.isNotBlank((String)collectionId)) {
            DocumentModel collection;
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
            IdRef collectionRef = new IdRef(collectionId);
            if (session.exists((DocumentRef)collectionRef) && collectionManager.canAddToCollection(collection = session.getDocument((DocumentRef)collectionRef), session)) {
                NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
                DocumentModel currentDocument = navigationContext.getCurrentDocument();
                collectionManager.removeFromCollection(collection, currentDocument, session);
                Events.instance().raiseEvent("documentChanged", new Object[0]);
                CollectionActionsBean.addFacesMessage(StatusMessage.Severity.INFO, "collection.removeCurrentDocumentFromCollection", collection.getTitle());
            }
        }
    }

    public void removeCurrentSelectionFromCollection() {
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        List doccumentListToBeRemoved = documentsListsManager.getWorkingList(COLLECTION_CURRENT_SELECTION);
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel collection = navigationContext.getCurrentDocument();
        this.removeFromCollection(collection, doccumentListToBeRemoved);
        documentsListsManager.resetWorkingList(COLLECTION_CURRENT_SELECTION);
    }

    public void removeFromCollection(DocumentModel collection, List<DocumentModel> documentListToBeRemoved) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        collectionManager.removeAllFromCollection(collection, documentListToBeRemoved, session);
        Events.instance().raiseEvent("documentChanged", new Object[0]);
        CollectionActionsBean.addFacesMessage(StatusMessage.Severity.INFO, "collection.removeCurrentSelectionFromCollection", collection.getTitle());
    }

    public void removeFromMultipleDocumentToBeAdded(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        DocumentsListsManager documentsListsManager = this.getDocumentsListsManager();
        DocumentModel toBeRemovedFromWorkingList = (DocumentModel)documentsListsManager.getWorkingList("CURRENT_SELECTION").get(Integer.valueOf(index));
        documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", toBeRemovedFromWorkingList);
    }

    public void setDocUidsToBeAdded(List<String> docUidsToBeAdded) {
        this.docUidsToBeAdded = docUidsToBeAdded;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public void setNewTitle(String newTitle) {
        this.newTitle = newTitle;
    }

    public void setSelectedCollectionUid(String selectedCollectionUid) {
        this.selectedCollection = null;
        this.selectedCollectionUid = selectedCollectionUid;
        if (this.isCreateNewCollection()) {
            this.setNewTitle(selectedCollectionUid.substring("-999999".length()));
        }
    }
}

