/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class RenditionDefinitionProviderRegistry
extends ContributionFragmentRegistry<RenditionDefinitionProviderDescriptor> {
    protected Map<String, RenditionDefinitionProviderDescriptor> descriptors = new HashMap<String, RenditionDefinitionProviderDescriptor>();

    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>();
        for (RenditionDefinitionProviderDescriptor descriptor : this.descriptors.values()) {
            if (!this.canUseRenditionDefinitionProvider(descriptor, doc)) continue;
            RenditionDefinitionProvider provider = descriptor.getProvider();
            renditionDefinitions.addAll(provider.getRenditionDefinitions(doc));
        }
        return renditionDefinitions;
    }

    public RenditionDefinition getRenditionDefinition(String name, DocumentModel doc) {
        List<RenditionDefinition> renditionDefinitions = this.getRenditionDefinitions(doc);
        for (RenditionDefinition renditionDefinition : renditionDefinitions) {
            if (!renditionDefinition.getName().equals(name)) continue;
            return renditionDefinition;
        }
        return null;
    }

    protected boolean canUseRenditionDefinitionProvider(RenditionDefinitionProviderDescriptor renditionDefinitionProviderDescriptor, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(renditionDefinitionProviderDescriptor.getFilterIds(), this.createActionContext(doc));
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext((ELContext)new ExpressionContext(), (ExpressionFactory)new ExpressionFactoryImpl());
        actionContext.setCurrentDocument(doc);
        actionContext.setDocumentManager(doc.getCoreSession());
        return actionContext;
    }

    public String getContributionId(RenditionDefinitionProviderDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, RenditionDefinitionProviderDescriptor contrib, RenditionDefinitionProviderDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            this.descriptors.put(id, contrib);
        } else {
            this.descriptors.remove(id);
        }
    }

    public void contributionRemoved(String id, RenditionDefinitionProviderDescriptor contrib) {
        this.descriptors.remove(id);
    }

    public RenditionDefinitionProviderDescriptor clone(RenditionDefinitionProviderDescriptor contrib) {
        return contrib.clone();
    }

    public void merge(RenditionDefinitionProviderDescriptor source, RenditionDefinitionProviderDescriptor dest) {
        Class<? extends RenditionDefinitionProvider> providerClass;
        if (source.isEnabledSet() && source.isEnabled() != dest.isEnabled()) {
            dest.setEnabled(source.isEnabled());
        }
        if ((providerClass = source.getProviderClass()) != null) {
            dest.setProviderClass(providerClass);
        }
        ArrayList<String> newFilterIds = new ArrayList<String>();
        newFilterIds.addAll(dest.getFilterIds());
        newFilterIds.addAll(source.getFilterIds());
        dest.setFilterIds(newFilterIds);
    }
}

