/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;

@XObject(value="renditionDefinitionProvider")
public class RenditionDefinitionProviderDescriptor {
    private static final Log log = LogFactory.getLog(RenditionDefinitionProviderDescriptor.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    Boolean enabled;
    @XNode(value="@class")
    protected Class<? extends RenditionDefinitionProvider> providerClass;
    protected RenditionDefinitionProvider provider;
    @XNodeList(value="filters/filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled != false;
    }

    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public Class<? extends RenditionDefinitionProvider> getProviderClass() {
        return this.providerClass;
    }

    public RenditionDefinitionProvider getProvider() {
        if (this.provider == null && this.providerClass != null) {
            try {
                this.provider = this.providerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error((Object)String.format("Unable to instantiate RenditionDefinitionProvider for '%s'", this.getName()), (Throwable)e);
            }
        }
        return this.provider;
    }

    public List<String> getFilterIds() {
        return this.filterIds;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setProviderClass(Class<? extends RenditionDefinitionProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public void setProvider(RenditionDefinitionProvider provider) {
        this.provider = provider;
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds = filterIds;
    }

    public RenditionDefinitionProviderDescriptor clone() {
        RenditionDefinitionProviderDescriptor clone = new RenditionDefinitionProviderDescriptor();
        clone.name = this.name;
        clone.enabled = this.enabled;
        clone.providerClass = this.providerClass;
        if (this.filterIds != null) {
            clone.filterIds = new ArrayList<String>();
            clone.filterIds.addAll(this.filterIds);
        }
        return clone;
    }
}

