/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.operation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;

@Operation(id="Document.GetRendition", category="Files", label="Gets a document rendition", description="Gets a document rendition given its name. Returns the rendition blob.")
public class GetRendition {
    public static final String ID = "Document.GetRendition";
    @Context
    protected RenditionService renditionService;
    @Param(name="renditionName")
    protected String renditionName;

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(DocumentModel doc) {
        Rendition rendition = this.renditionService.getRendition(doc, this.renditionName);
        Blob blob = rendition.getBlob();
        if (blob == null) {
            blob = Blobs.createBlob((String)"");
            blob.setFilename(doc.getName() + ".null");
        }
        return blob;
    }
}

