/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.util.Calendar;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.Sorter;

public class CommentSorter
implements Sorter {
    private static final long serialVersionUID = 1L;
    private boolean asc = true;

    public CommentSorter(boolean asc) {
        this.asc = asc;
    }

    public int compare(DocumentModel doc1, DocumentModel doc2) {
        if (doc1 == null && doc2 == null) {
            return 0;
        }
        if (doc1 == null) {
            return this.asc ? -1 : 1;
        }
        if (doc2 == null) {
            return this.asc ? 1 : -1;
        }
        int cmp = 0;
        try {
            Calendar created1 = (Calendar)doc1.getPropertyValue("dc:created");
            Calendar created2 = (Calendar)doc2.getPropertyValue("dc:created");
            if (created1 == null && created2 == null) {
                return 0;
            }
            if (created1 == null) {
                return this.asc ? -1 : 1;
            }
            if (created2 == null) {
                return this.asc ? 1 : -1;
            }
            cmp = created1.compareTo(created2);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return this.asc ? cmp : -cmp;
    }
}

