/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.io;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentPropertiesJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DirectoryEntryJsonReader
extends EntityJsonReader<DirectoryEntry> {
    @Inject
    private DirectoryService directoryService;

    public DirectoryEntryJsonReader() {
        super("directoryEntry");
    }

    protected DirectoryEntry readEntity(JsonNode jn) throws IOException {
        String directoryName = this.getStringField(jn, "directoryName");
        Directory directory = this.directoryService.getDirectory(directoryName);
        String schema = directory.getSchema();
        JsonNode propsNode = jn.get("properties");
        if (propsNode != null && !propsNode.isNull() && propsNode.isObject()) {
            String id = this.getStringField(propsNode, directory.getIdField());
            try (Session session = directory.getSession();){
                DocumentModel entry = session.getEntry(id);
                if (entry == null) {
                    entry = BaseSession.createEntryModel(null, (String)schema, (String)id, new HashMap());
                }
                ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
                try (Closeable resource = this.ctx.wrap().with(DocumentPropertiesJsonReader.DEFAULT_SCHEMA_NAME, (Object)schema).open();){
                    List properties = (List)this.readEntity(List.class, genericType, propsNode);
                    for (Property property : properties) {
                        entry.setPropertyValue(property.getName(), property.getValue());
                    }
                }
                DirectoryEntry directoryEntry = new DirectoryEntry(directory.getName(), entry);
                return directoryEntry;
            }
        }
        return null;
    }
}

