/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.identity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.identity.Base64;

public class LogicalInstanceIdentifier {
    protected static final String KEY_FILE = "instance.clid";
    protected static final String NUXEO_DATA_DIR_KEY = "nuxeo.data.dir";
    public static final String ID_SEP = "--";
    public static boolean USE_BASE64_SAVE = false;
    protected String instanceDescription = "";
    protected NuxeoClientInstanceType instanceType = NuxeoClientInstanceType.DEV;
    protected String CLID1 = null;
    protected String CLID2 = null;
    protected static LogicalInstanceIdentifier instance;

    public LogicalInstanceIdentifier(String ID, String description) throws InvalidCLID {
        this(ID);
        this.instanceDescription = description;
    }

    public LogicalInstanceIdentifier(String ID) throws InvalidCLID {
        String[] parts = ID.split(ID_SEP);
        if (parts.length != 2) {
            throw new InvalidCLID("CLID is not of the right format");
        }
        this.CLID1 = parts[0];
        this.CLID2 = parts[1];
    }

    public String getCLID() {
        return this.CLID1 + ID_SEP + this.CLID2;
    }

    public String getInstanceDescription() {
        return this.instanceDescription;
    }

    public void setInstanceDescription(String instanceDescription) {
        this.instanceDescription = instanceDescription;
    }

    public NuxeoClientInstanceType getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(NuxeoClientInstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public String getCLID1() {
        return this.CLID1;
    }

    public String getCLID2() {
        return this.CLID2;
    }

    protected static String getSaveFileName(boolean load) {
        File keyFile;
        String path = NuxeoConnectClient.getProperty(NUXEO_DATA_DIR_KEY, NuxeoConnectClient.getHomePath());
        if (path == null) {
            path = System.getProperty("java.tmp.dir");
        }
        if (!(keyFile = new File(path, KEY_FILE)).exists() && load) {
            keyFile = new File(NuxeoConnectClient.getHomePath(), KEY_FILE);
        }
        return keyFile.getPath();
    }

    public static void cleanUp() {
        instance = null;
        File file = new File(LogicalInstanceIdentifier.getSaveFileName(false));
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        String data = this.CLID1 + "\n" + this.CLID2 + "\n" + this.instanceDescription + "\n";
        if (USE_BASE64_SAVE) {
            data = Base64.encodeBytes(data.getBytes());
        }
        File file = new File(LogicalInstanceIdentifier.getSaveFileName(false));
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            fos.write(data.getBytes());
        }
    }

    public static LogicalInstanceIdentifier instance() throws NoCLID {
        if (instance == null) {
            try {
                LogicalInstanceIdentifier.load();
            }
            catch (IOException | InvalidCLID e) {
                throw new NoCLID("can not load CLID", e);
            }
        }
        return instance;
    }

    public static void unload() throws Exception {
        instance = null;
    }

    public static LogicalInstanceIdentifier load(String path) throws IOException, InvalidCLID {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        List<String> lines = LogicalInstanceIdentifier.readLines(file);
        if (USE_BASE64_SAVE) {
            byte[] data = Base64.decode(lines.get(0));
            String strData = new String(data);
            String[] parts = strData.split("\n");
            lines = new ArrayList<String>();
            for (String part : parts) {
                lines.add(part);
            }
        }
        if (lines.size() < 2) {
            throw new InvalidCLID(String.format("CLID file (%s) is invalid", path));
        }
        String id = lines.get(0) + ID_SEP + lines.get(1);
        String description = lines.size() > 2 ? lines.get(2) : "";
        instance = new LogicalInstanceIdentifier(id, description);
        return instance;
    }

    public static LogicalInstanceIdentifier load() throws IOException, InvalidCLID {
        return LogicalInstanceIdentifier.load(LogicalInstanceIdentifier.getSaveFileName(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    public static boolean isRegistered() {
        try {
            LogicalInstanceIdentifier.instance();
            return true;
        }
        catch (NoCLID e) {
            return false;
        }
    }

    public static class NoCLID
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoCLID(String message) {
            super(message);
        }

        public NoCLID(String message, Exception e) {
            super(message, e);
        }
    }

    public static class InvalidCLID
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidCLID(String message) {
            super(message);
        }
    }
}

