/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.fake;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ProductionState;
import org.nuxeo.connect.update.Version;

public class FakeDownloadablePackage
implements DownloadablePackage {
    private String name;
    private Version version;
    private String classifier;
    private List<PackageDependency> dependencies = new ArrayList<PackageDependency>();
    private List<PackageDependency> conflicts = new ArrayList<PackageDependency>();
    public String id;
    public String title;
    public String description;
    public PackageType type;
    public String vendor;
    public List<String> targetPlatforms = new ArrayList<String>();
    public PackageState packageState = PackageState.UNKNOWN;
    public String homePage;
    public String licenseType;
    public String licenseUrl;
    public ProductionState productionState;
    public NuxeoValidationState validationState;
    public PackageVisibility visibility;

    public FakeDownloadablePackage(String name, Version version) {
        this.name = name;
        this.version = version;
        this.classifier = version.classifier();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.targetPlatforms.toArray(new String[this.targetPlatforms.size()]);
    }

    @Override
    public PackageDependency[] getDependencies() {
        return this.dependencies.toArray(new PackageDependency[this.dependencies.size()]);
    }

    @Override
    public PackageDependency[] getConflicts() {
        return this.conflicts.toArray(new PackageDependency[this.conflicts.size()]);
    }

    @Override
    public PackageDependency[] getProvides() {
        return null;
    }

    @Override
    @Deprecated
    public int getState() {
        return this.packageState.getValue();
    }

    @Override
    public PackageState getPackageState() {
        return this.packageState;
    }

    @Override
    public String getHomePage() {
        return this.homePage;
    }

    @Override
    public String getLicenseType() {
        return this.licenseType;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public boolean isLocal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProductionState getProductionState() {
        return this.productionState;
    }

    @Override
    public NuxeoValidationState getValidationState() {
        return this.validationState;
    }

    @Override
    public boolean supportsHotReload() {
        return false;
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public String getSourceDigest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceUrl() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSourceSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRating() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCommentsNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPictureUrl() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDownloadsCount() {
        throw new UnsupportedOperationException();
    }

    public void addDependency(PackageDependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addConflict(PackageDependency conflict) {
        this.conflicts.add(conflict);
    }

    @Override
    public PackageVisibility getVisibility() {
        return this.visibility;
    }
}

