/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class MD2TextConverter
implements Converter {
    private static final Log LOGGER = LogFactory.getLog(MD2TextConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            Blob blob = blobHolder.getBlob();
            if (blob == null) {
                LOGGER.warn((Object)"Trying to convert a blobHolder that has a null blob. Nothing to do, returning the blobHolder.");
                return blobHolder;
            }
            String text = blob.getString();
            return new SimpleCachableBlobHolder(Blobs.createBlob((String)text));
        }
        catch (IOException e) {
            throw new ConversionException("Error during MD2Text conversion", (Throwable)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

