/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class MimetypeIconUpdater
implements EventListener {
    protected Log log = LogFactory.getLog(MimetypeIconUpdater.class);
    public static final String ICON_SCHEMA = "common";
    public static final String ICON_FIELD = "common:icon";
    public static final String MAIN_BLOB_FIELD = "file:content";
    public static final String MAIN_BLOB_SCHEMA = "file";
    @Deprecated
    private static final String SIZE_FIELD = "common:size";
    @Deprecated
    public static final String MAIN_EXTERNAL_FILENAME_FIELD = "file:filename";
    protected static final String OCTET_STREAM_MT = "application/octet-stream";
    public final BlobsExtractor blobExtractor = new BlobsExtractor();
    MimetypeRegistry mimetypeService;

    public MimetypeRegistry getMimetypeRegistry() {
        if (this.mimetypeService == null) {
            this.mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimetypeService;
    }

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc.hasFacet("Immutable")) {
                return;
            }
            this.updateFilename(doc);
            try {
                this.setDefaultIcon(doc);
                for (Property prop : this.blobExtractor.getBlobsProperties(doc)) {
                    if (!prop.isDirty()) continue;
                    this.updateBlobProperty(doc, this.getMimetypeRegistry(), prop);
                }
                if (doc.hasSchema(MAIN_BLOB_SCHEMA) && doc.getProperty(MAIN_BLOB_FIELD).isDirty()) {
                    this.updateIconAndSizeFields(doc, this.getMimetypeRegistry(), (Blob)doc.getProperty(MAIN_BLOB_FIELD).getValue(Blob.class));
                }
            }
            catch (PropertyException e) {
                e.addInfo("Error in MimetypeIconUpdater listener");
                throw e;
            }
        }
    }

    @Deprecated
    public void recursivelyUpdateBlobs(DocumentModel doc, MimetypeRegistry mimetypeService, Iterator<Property> dirtyChildren) {
        while (dirtyChildren.hasNext()) {
            Property dirtyProperty = dirtyChildren.next();
            if (dirtyProperty instanceof BlobProperty) {
                this.updateBlobProperty(doc, mimetypeService, dirtyProperty);
                continue;
            }
            if (!dirtyProperty.isContainer()) continue;
            this.recursivelyUpdateBlobs(doc, mimetypeService, dirtyProperty.getDirtyChildren());
        }
    }

    public void updateBlobProperty(DocumentModel doc, MimetypeRegistry mimetypeService, Property dirtyProperty) {
        Blob blob;
        String fieldPath = dirtyProperty.getPath();
        if (!fieldPath.contains(":")) {
            fieldPath = dirtyProperty.getSchema().getName() + ":" + fieldPath.substring(1);
        }
        if ((blob = (Blob)dirtyProperty.getValue(Blob.class)) != null && (blob.getMimeType() == null || blob.getMimeType().equals(OCTET_STREAM_MT))) {
            blob = mimetypeService.updateMimetype(blob);
            doc.setPropertyValue(fieldPath, (Serializable)blob);
        }
    }

    private void updateIconAndSizeFields(DocumentModel doc, MimetypeRegistry mimetypeService, Blob blob) throws PropertyException {
        if (blob != null && !doc.isFolder()) {
            MimetypeEntry mimetypeEntry = mimetypeService.getMimetypeEntryByMimeType(blob.getMimeType());
            this.updateIconField(mimetypeEntry, doc);
        } else {
            this.updateIconField(null, doc);
        }
        doc.setPropertyValue(SIZE_FIELD, (Serializable)Long.valueOf(blob != null ? blob.getLength() : 0L));
    }

    public void updateFilename(DocumentModel doc) throws PropertyException {
        Property filenameProperty;
        if (doc.hasSchema(MAIN_BLOB_FIELD.split(":")[0]) && (filenameProperty = doc.getProperty(MAIN_EXTERNAL_FILENAME_FIELD)).isDirty()) {
            String filename = (String)filenameProperty.getValue(String.class);
            if (doc.getProperty(MAIN_BLOB_FIELD).getValue() != null) {
                Blob blob = (Blob)doc.getProperty(MAIN_BLOB_FIELD).getValue(Blob.class);
                blob.setFilename(filename);
                doc.setPropertyValue(MAIN_BLOB_FIELD, (Serializable)blob);
            }
        }
    }

    public void setDefaultIcon(DocumentModel doc) {
        if (doc.hasSchema(ICON_SCHEMA) && doc.getProperty(ICON_FIELD).getValue(String.class) == null) {
            this.updateIconField(null, doc);
        }
    }

    public void updateIconField(MimetypeEntry mimetypeEntry, DocumentModel doc) {
        String iconPath = null;
        if (mimetypeEntry != null && mimetypeEntry.getIconPath() != null) {
            iconPath = "/icons/" + mimetypeEntry.getIconPath();
        } else {
            TypeManager typeManager = (TypeManager)Framework.getService(TypeManager.class);
            if (typeManager == null) {
                return;
            }
            Type uiType = typeManager.getType(doc.getType());
            if (uiType != null) {
                iconPath = uiType.getIcon();
            }
        }
        if (iconPath != null && doc.hasSchema(ICON_SCHEMA)) {
            doc.setPropertyValue(ICON_FIELD, (Serializable)((Object)iconPath));
        }
    }
}

