/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.io;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.EntityWriter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.io.JsonEncodeDecodeUtils;

@Provider
@Produces(value={"application/json", "application/json+nxentity"})
public class DocumentRouteWriter
extends EntityWriter<DocumentRoute> {
    public static final String ENTITY_TYPE = "workflow";
    @Context
    HttpServletRequest request;
    @Context
    UriInfo uriInfo;

    protected void writeEntityBody(JsonGenerator jg, DocumentRoute item) throws IOException {
        DocumentRouteWriter.writeDocumentRoute(jg, item, this.request, this.uriInfo);
    }

    public static void writeDocumentRoute(JsonGenerator jg, DocumentRoute item, HttpServletRequest request, UriInfo uriInfo) throws JsonGenerationException, IOException {
        jg.writeStringField("id", item.getDocument().getId());
        jg.writeStringField("name", item.getName());
        jg.writeStringField("title", item.getTitle());
        jg.writeStringField("state", item.getDocument().getCurrentLifeCycleState());
        jg.writeStringField("workflowModelName", item.getModelName());
        jg.writeStringField("initiator", item.getInitiator());
        jg.writeArrayFieldStart("attachedDocumentIds");
        for (Object docId : item.getAttachedDocuments()) {
            jg.writeStartObject();
            jg.writeStringField("id", (String)docId);
            jg.writeEndObject();
        }
        jg.writeEndArray();
        if (item instanceof GraphRoute) {
            GraphRoute graphRoute = (GraphRoute)item;
            jg.writeFieldName("variables");
            jg.writeStartObject();
            for (Map.Entry entry : graphRoute.getVariables().entrySet()) {
                JsonEncodeDecodeUtils.encodeVariableEntry((DocumentModel)item.getDocument(), (String)"docri:variablesFacet", (Map.Entry)entry, (JsonGenerator)jg, (HttpServletRequest)request);
            }
            jg.writeEndObject();
            String graphResourceUrl = "";
            graphResourceUrl = item.isValidated() ? uriInfo.getBaseUri() + "api/v1/workflowModel/" + item.getDocument().getName() + "/graph" : uriInfo.getBaseUri() + "api/v1/workflow/" + item.getDocument().getId() + "/graph";
            jg.writeStringField("graphResource", graphResourceUrl);
        }
    }

    protected String getEntityType() {
        return ENTITY_TYPE;
    }
}

