/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.AbstractUserWorkspaceImpl;

public class DefaultUserWorkspaceServiceImpl
extends AbstractUserWorkspaceImpl
implements UserWorkspaceService {
    private static final long serialVersionUID = 1L;

    protected String getUserWorkspaceRootType() {
        return this.getComponent().getConfiguration().getUserWorkspaceRootType();
    }

    protected String getUserWorkspaceType() {
        return this.getComponent().getConfiguration().getUserWorkspaceType();
    }

    protected void setUserWorkspaceRootACL(DocumentModel doc) {
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{denyEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
    }

    protected void setUserWorkspaceACL(DocumentModel doc, String userName) {
        ACPImpl acp = new ACPImpl();
        ACE grantEverything = new ACE(userName, "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
    }

    @Override
    protected DocumentModel doCreateUserWorkspacesRoot(CoreSession unrestrictedSession, PathRef rootRef) {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, "UserWorkspaces", this.getUserWorkspaceRootType());
        doc.setProperty("dublincore", "title", (Object)"UserWorkspaces");
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        this.setUserWorkspaceRootACL(doc);
        return doc;
    }

    @Override
    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, Principal principal, String userName) {
        String parentPath = new Path(wsRef.toString()).removeLastSegments(1).toString();
        String wsName = new Path(wsRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, wsName, this.getUserWorkspaceType());
        doc.setProperty("dublincore", "title", (Object)this.buildUserWorkspaceTitle(principal, userName));
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        this.setUserWorkspaceACL(doc, userName);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("username", (Serializable)((Object)userName));
        this.notifyEvent(unrestrictedSession, doc, (NuxeoPrincipal)unrestrictedSession.getPrincipal(), "userWorkspaceCreated", properties);
        return doc;
    }
}

