/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.operations;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Blob.SetMetadataFromContext", category="Files", label="Write Metadata To Blob From Context", description="Write Metadata To Blob From Context given a processor name (or the default Nuxeo one) and given metadata, and return the updated Blob.", since="7.1", addToStudio=true, aliases={"Binary.WriteMetadataFromContext"})
public class WriteMetadataToBinaryFromContext {
    public static final String ID = "Blob.SetMetadataFromContext";
    @Context
    protected BinaryMetadataService binaryMetadataService;
    @Param(name="ignorePrefix", required=false, description="Ignore metadata prefixes or not")
    boolean ignorePrefix = true;
    @Param(name="processor", required=false, description="The processor to execute for overriding the input blob.")
    protected String processor = "exifTool";
    @Param(name="metadata", required=true, description="Metadata to write into the input blob.")
    protected Properties metadata;

    @OperationMethod
    public Blob run(Blob blob) {
        HashMap<String, String> metadataMap = new HashMap<String, String>(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            metadataMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return this.binaryMetadataService.writeMetadata(this.processor, blob, metadataMap, this.ignorePrefix);
    }
}

