/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.elasticsearch.http.readonly.filter.SearchRequestFilter;
import org.nuxeo.elasticsearch.http.readonly.service.RequestFilterDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class RequestFilterService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("service", "org.nuxeo.elasticsearch.http.readonly.RequestFilterService");
    private static final Log log = LogFactory.getLog(RequestFilterService.class);
    protected static final String FILTER_EXT_POINT = "filters";
    protected Map<String, Class> requestFilters;

    public void activate(ComponentContext context) {
        this.requestFilters = new ConcurrentHashMap<String, Class>();
    }

    public void deactivate(ComponentContext context) {
        this.requestFilters.clear();
        this.requestFilters = null;
    }

    public Map<String, Class> getRequestFilters() {
        return this.requestFilters;
    }

    public SearchRequestFilter getRequestFilters(String indices) throws InstantiationException, IllegalAccessException {
        Class clazz = this.requestFilters.get(indices);
        if (clazz == null) {
            return null;
        }
        return (SearchRequestFilter)clazz.newInstance();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILTER_EXT_POINT.equals(extensionPoint)) {
            RequestFilterDescriptor des = (RequestFilterDescriptor)contribution;
            this.requestFilters.put(des.getIndex(), des.getFilterClass());
            log.info((Object)("Registered filter: " + des.getFilterClass() + " for index " + des.getIndex()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        RequestFilterDescriptor des;
        Class filter;
        if (FILTER_EXT_POINT.equals(extensionPoint) && (filter = this.requestFilters.remove((des = (RequestFilterDescriptor)contribution).getIndex())) != null) {
            log.info((Object)("Unregistered filter: " + filter + " for index " + des.getIndex()));
        }
    }
}

