/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSConfigurationException;
import com.thetransactioncompany.cors.CORSConfigurationLoader;
import com.thetransactioncompany.cors.CORSOriginDeniedException;
import com.thetransactioncompany.cors.CORSRequestHandler;
import com.thetransactioncompany.cors.CORSRequestType;
import com.thetransactioncompany.cors.CORSResponseWrapper;
import com.thetransactioncompany.cors.InvalidCORSRequestException;
import com.thetransactioncompany.cors.RequestTagger;
import com.thetransactioncompany.cors.UnsupportedHTTPHeaderException;
import com.thetransactioncompany.cors.UnsupportedHTTPMethodException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSFilter
implements Filter {
    private CORSConfiguration config;
    private CORSRequestHandler handler;

    public CORSFilter() {
    }

    public CORSFilter(CORSConfiguration config) {
        this.setConfiguration(config);
    }

    public void setConfiguration(CORSConfiguration config) {
        this.config = config;
        this.handler = new CORSRequestHandler(config);
    }

    public CORSConfiguration getConfiguration() {
        return this.config;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        CORSConfigurationLoader configLoader = new CORSConfigurationLoader(filterConfig);
        try {
            this.setConfiguration(configLoader.load());
        }
        catch (CORSConfigurationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void printMessage(HttpServletResponse response, int sc, String msg) throws IOException, ServletException {
        response.setStatus(sc);
        response.resetBuffer();
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("Cross-Origin Resource Sharing (CORS) Filter: " + msg);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CORSRequestType type = CORSRequestType.detect(request);
        if (this.config.tagRequests) {
            RequestTagger.tag(request, type);
        }
        try {
            if (type.equals((Object)CORSRequestType.ACTUAL)) {
                this.handler.handleActualRequest(request, response);
                CORSResponseWrapper responseWrapper = new CORSResponseWrapper(response);
                chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            } else if (type.equals((Object)CORSRequestType.PREFLIGHT)) {
                this.handler.handlePreflightRequest(request, response);
            } else if (this.config.allowGenericHttpRequests) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.printMessage(response, 403, "Generic HTTP requests not allowed");
            }
        }
        catch (InvalidCORSRequestException e) {
            this.printMessage(response, 400, e.getMessage());
        }
        catch (CORSOriginDeniedException e) {
            String msg = e.getMessage();
            if (e.getRequestOrigin() != null) {
                msg = msg + ": " + e.getRequestOrigin();
            }
            this.printMessage(response, 403, msg);
        }
        catch (UnsupportedHTTPMethodException e) {
            String msg = e.getMessage();
            String method = e.getRequestedMethod();
            if (method != null) {
                msg = msg + ": " + method;
            }
            this.printMessage(response, 405, msg);
        }
        catch (UnsupportedHTTPHeaderException e) {
            String msg = e.getMessage();
            String header = e.getRequestHeader();
            if (header != null) {
                msg = msg + ": " + header;
            }
            this.printMessage(response, 403, msg);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Cannot filter non-HTTP requests/responses");
        }
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void destroy() {
    }
}

