/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.InitialStateDescriptor;
import org.nuxeo.ecm.core.versioning.SaveOptionsDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;

public class StandardVersioningService
implements ExtendableVersioningService {
    private static final Log log = LogFactory.getLog(StandardVersioningService.class);
    public static final String FILE_TYPE = "File";
    public static final String NOTE_TYPE = "Note";
    public static final String PROJECT_STATE = "project";
    public static final String APPROVED_STATE = "approved";
    public static final String OBSOLETE_STATE = "obsolete";
    public static final String BACK_TO_PROJECT_TRANSITION = "backToProject";
    protected static final String AUTO_CHECKED_OUT = "AUTO_CHECKED_OUT";
    protected static final String MAJOR_VERSION = "ecm:majorVersion";
    protected static final String MINOR_VERSION = "ecm:minorVersion";
    private Map<String, VersioningRuleDescriptor> versioningRules;
    private DefaultVersioningRuleDescriptor defaultVersioningRule;

    @Override
    public String getVersionLabel(DocumentModel docModel) {
        String label;
        try {
            label = this.getMajor(docModel) + "." + this.getMinor(docModel);
            if (docModel.isCheckedOut() && !"0.0".equals(label)) {
                label = label + "+";
            }
        }
        catch (PropertyNotFoundException e) {
            label = "";
        }
        return label;
    }

    protected long getMajor(DocumentModel docModel) {
        return this.getVersion(docModel, "uid:major_version");
    }

    protected long getMinor(DocumentModel docModel) {
        return this.getVersion(docModel, "uid:minor_version");
    }

    protected long getVersion(DocumentModel docModel, String prop) {
        Serializable propVal = docModel.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return 0L;
        }
        return (Long)propVal;
    }

    protected long getMajor(Document doc) {
        return this.getVersion(doc, MAJOR_VERSION);
    }

    protected long getMinor(Document doc) {
        return this.getVersion(doc, MINOR_VERSION);
    }

    protected long getVersion(Document doc, String prop) {
        Serializable propVal = doc.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return 0L;
        }
        return (Long)propVal;
    }

    protected void setVersion(Document doc, long major, long minor) {
        doc.setPropertyValue(MAJOR_VERSION, Long.valueOf(major));
        doc.setPropertyValue(MINOR_VERSION, Long.valueOf(minor));
    }

    protected void incrementMajor(Document doc) {
        this.setVersion(doc, this.getMajor(doc) + 1L, 0L);
    }

    protected void incrementMinor(Document doc) {
        doc.setPropertyValue(MINOR_VERSION, Long.valueOf(this.getMinor(doc) + 1L));
    }

    protected void incrementByOption(Document doc, VersioningOption option) {
        try {
            if (option == VersioningOption.MAJOR) {
                this.incrementMajor(doc);
            } else if (option == VersioningOption.MINOR) {
                this.incrementMinor(doc);
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        if (doc.isVersion() || doc.isProxy()) {
            return;
        }
        this.setInitialVersion(doc);
    }

    protected void setInitialVersion(Document doc) {
        VersioningRuleDescriptor versionRule;
        InitialStateDescriptor initialState = null;
        if (this.versioningRules != null && (versionRule = this.versioningRules.get(doc.getType().getName())) != null) {
            initialState = versionRule.getInitialState();
        }
        if (initialState == null && this.defaultVersioningRule != null) {
            initialState = this.defaultVersioningRule.getInitialState();
        }
        if (initialState != null) {
            int initialMajor = initialState.getMajor();
            int initialMinor = initialState.getMinor();
            this.setVersion(doc, initialMajor, initialMinor);
            return;
        }
        this.setVersion(doc, 0L, 0L);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) {
        boolean versionable = docModel.isVersionable();
        String lifecycleState = docModel.getCoreSession().getCurrentLifeCycleState(docModel.getRef());
        String type = docModel.getType();
        return this.getSaveOptions(versionable, lifecycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(Document doc) {
        String lifecycleState;
        boolean versionable = doc.getType().getFacets().contains("Versionable");
        try {
            lifecycleState = doc.getLifeCycleState();
        }
        catch (LifeCycleException e) {
            lifecycleState = null;
        }
        String type = doc.getType().getName();
        return this.getSaveOptions(versionable, lifecycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(boolean versionable, String lifecycleState, String type) {
        VersioningRuleDescriptor saveOption;
        if (!versionable) {
            return Arrays.asList(VersioningOption.NONE);
        }
        if (lifecycleState == null) {
            return Arrays.asList(VersioningOption.NONE);
        }
        SaveOptionsDescriptor option = null;
        if (this.versioningRules != null && (saveOption = this.versioningRules.get(type)) != null && (option = saveOption.getOptions().get(lifecycleState)) == null) {
            option = saveOption.getOptions().get("*");
        }
        if (option == null && this.defaultVersioningRule != null && (option = this.defaultVersioningRule.getOptions().get(lifecycleState)) == null) {
            option = this.defaultVersioningRule.getOptions().get("*");
        }
        if (option != null) {
            return option.getVersioningOptionList();
        }
        if (PROJECT_STATE.equals(lifecycleState) || APPROVED_STATE.equals(lifecycleState) || OBSOLETE_STATE.equals(lifecycleState)) {
            return Arrays.asList(VersioningOption.NONE, VersioningOption.MINOR, VersioningOption.MAJOR);
        }
        if (FILE_TYPE.equals(type) || NOTE_TYPE.equals(type)) {
            return Arrays.asList(VersioningOption.NONE, VersioningOption.MINOR, VersioningOption.MAJOR);
        }
        return Arrays.asList(VersioningOption.NONE);
    }

    protected VersioningOption validateOption(Document doc, VersioningOption option) {
        List<VersioningOption> options = this.getSaveOptions(doc);
        if (!options.contains(option)) {
            option = options.isEmpty() ? VersioningOption.NONE : options.get(0);
        }
        return option;
    }

    @Override
    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) {
        boolean disableAutoCheckOut = Boolean.TRUE.equals(options.get("DisableAutoCheckOut"));
        return !doc.isCheckedOut() && isDirty && !disableAutoCheckOut;
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        if (this.isPreSaveDoingCheckOut(doc, isDirty, option = this.validateOption(doc, option), options)) {
            this.doCheckOut(doc);
            this.followTransitionByOption(doc, option);
        }
        return option;
    }

    protected void followTransitionByOption(Document doc, VersioningOption option) {
        String lifecycleState = doc.getLifeCycleState();
        if (APPROVED_STATE.equals(lifecycleState) || OBSOLETE_STATE.equals(lifecycleState)) {
            doc.followTransition(BACK_TO_PROJECT_TRANSITION);
        }
    }

    @Override
    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) {
        return doc.isCheckedOut() && option != VersioningOption.NONE;
    }

    @Override
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        if (this.isPostSaveDoingCheckIn(doc, option, options)) {
            this.incrementByOption(doc, option);
            return doc.checkIn(null, checkinComment);
        }
        return null;
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) {
        if (option != VersioningOption.NONE) {
            this.incrementByOption(doc, option == VersioningOption.MAJOR ? VersioningOption.MAJOR : VersioningOption.MINOR);
        }
        return doc.checkIn(null, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) {
        Document last;
        Document base = doc.getBaseVersion();
        doc.checkOut();
        if (!base.isLatestVersion() && (last = doc.getLastVersion()) != null) {
            try {
                this.setVersion(doc, this.getMajor(last), this.getMinor(last));
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return this.versioningRules;
    }

    @Override
    public void setVersioningRules(Map<String, VersioningRuleDescriptor> versioningRules) {
        this.versioningRules = versioningRules;
    }

    @Override
    public void setDefaultVersioningRule(DefaultVersioningRuleDescriptor defaultVersioningRule) {
        this.defaultVersioningRule = defaultVersioningRule;
    }
}

