/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.Prefetch;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelFactory {
    private static final Log log = LogFactory.getLog(DocumentModelFactory.class);

    private DocumentModelFactory() {
    }

    public static DocumentModelImpl createDocumentModel(Document doc, String sid, String[] schemas) {
        String[] prefetchSchemas;
        Prefetch prefetch;
        PrefetchInfo prefetchInfo;
        DocumentType type = doc.getType();
        if (type == null) {
            throw new NuxeoException("Type not found for doc " + doc);
        }
        IdRef docRef = new IdRef(doc.getUUID());
        Document parent = doc.getParent();
        IdRef parentRef = parent == null ? null : new IdRef(parent.getUUID());
        Document sourceDoc = doc.getSourceDocument();
        String sourceId = sourceDoc == null ? null : sourceDoc.getUUID();
        boolean immutable = doc.isVersion() || doc.isProxy() && sourceDoc.isVersion();
        HashSet<String> facets = new HashSet<String>(Arrays.asList(doc.getFacets()));
        if (immutable) {
            facets.add("Immutable");
        }
        String repositoryName = doc.getRepositoryName();
        String p = doc.getPath();
        Path path = p == null ? null : new Path(p);
        DocumentModelImpl docModel = new DocumentModelImpl(sid, type.getName(), doc.getUUID(), path, (DocumentRef)docRef, (DocumentRef)parentRef, null, facets, sourceId, repositoryName, doc.isProxy());
        docModel.setPosInternal(doc.getPos());
        if (doc.isVersion()) {
            docModel.setIsVersion(true);
        }
        if (immutable) {
            docModel.setIsImmutable(true);
        }
        if ((prefetchInfo = type.getPrefetchInfo()) != null) {
            HashSet<String> docSchemas = new HashSet<String>(Arrays.asList(docModel.getSchemas()));
            prefetch = DocumentModelFactory.getPrefetch(doc, prefetchInfo, docSchemas);
            prefetchSchemas = prefetchInfo.getSchemas();
        } else {
            prefetch = null;
            prefetchSchemas = null;
        }
        LinkedList<Object> loadSchemas = new LinkedList<Object>();
        if (schemas == null) {
            schemas = prefetchSchemas;
        }
        if (schemas != null) {
            HashSet<String> validSchemas = new HashSet<String>(Arrays.asList(docModel.getSchemas()));
            for (String schemaName : schemas) {
                if (!validSchemas.contains(schemaName)) continue;
                loadSchemas.add(schemaName);
            }
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        for (String string : loadSchemas) {
            Schema schema = schemaManager.getSchema(string);
            docModel.addDataModel(DocumentModelFactory.createDataModel(doc, schema));
        }
        if (prefetch != null) {
            for (String string : loadSchemas) {
                prefetch.clearPrefetch(string);
            }
            docModel.setPrefetch(prefetch);
        }
        try {
            String lifeCycleState = doc.getLifeCycleState();
            docModel.prefetchCurrentLifecycleState(lifeCycleState);
            String string = doc.getLifeCyclePolicy();
            docModel.prefetchLifeCyclePolicy(string);
        }
        catch (LifeCycleException e) {
            log.debug((Object)("Cannot prefetch lifecycle for doc: " + doc.getName() + ". Error: " + e.getMessage()));
        }
        return docModel;
    }

    public static DocumentModelImpl createDocumentModel(String docType) {
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DocumentType type = schemaManager.getDocumentType(docType);
        return DocumentModelFactory.createDocumentModel(null, type);
    }

    public static DocumentModelImpl createDocumentModel(String sessionId, DocumentType docType) {
        DocumentModelImpl docModel = new DocumentModelImpl(sessionId, docType.getName(), null, null, null, null, null, null, null, null, null);
        for (Schema schema : docType.getSchemas()) {
            docModel.addDataModel(DocumentModelFactory.createDataModel(null, schema));
        }
        return docModel;
    }

    public static DataModel createDataModel(Document doc, Schema schema) {
        DocumentPartImpl part = new DocumentPartImpl(schema);
        if (doc != null) {
            doc.readDocumentPart((DocumentPart)part);
        }
        return new DataModelImpl((DocumentPart)part);
    }

    public static DocumentModel writeDocumentModel(DocumentModel docModel, Document doc) {
        if (!(docModel instanceof DocumentModelImpl)) {
            throw new NuxeoException("Must be a DocumentModelImpl: " + docModel);
        }
        boolean changed = false;
        Set instanceFacets = ((DocumentModelImpl)docModel).instanceFacets;
        Set instanceFacetsOrig = ((DocumentModelImpl)docModel).instanceFacetsOrig;
        HashSet addedFacets = new HashSet(instanceFacets);
        addedFacets.removeAll(instanceFacetsOrig);
        for (Object facet : addedFacets) {
            changed = doc.addFacet((String)facet) || changed;
        }
        HashSet removedFacets = new HashSet(instanceFacetsOrig);
        removedFacets.removeAll(instanceFacets);
        for (Object facet : removedFacets) {
            changed = doc.removeFacet((String)facet) || changed;
        }
        Document.WriteContext writeContext = doc.getWriteContext();
        for (DataModel dm : docModel.getDataModelsCollection()) {
            if (!dm.isDirty()) continue;
            DocumentPart part = ((DataModelImpl)dm).getDocumentPart();
            changed = doc.writeDocumentPart(part, writeContext) || changed;
        }
        writeContext.flush(doc);
        if (!changed) {
            return docModel;
        }
        DocumentModelImpl newModel = DocumentModelFactory.createDocumentModel(doc, docModel.getSessionId(), null);
        newModel.copyContextData(docModel);
        return newModel;
    }

    public static DocumentModel.DocumentModelRefresh refreshDocumentModel(Document doc, int flags, String[] schemas) throws LifeCycleException {
        PrefetchInfo prefetchInfo;
        DocumentModel.DocumentModelRefresh refresh = new DocumentModel.DocumentModelRefresh();
        refresh.instanceFacets = new HashSet<String>(Arrays.asList(doc.getFacets()));
        Set docSchemas = DocumentModelImpl.computeSchemas((DocumentType)doc.getType(), (Collection)refresh.instanceFacets, (boolean)doc.isProxy());
        if ((flags & 4) != 0 && (prefetchInfo = doc.getType().getPrefetchInfo()) != null) {
            refresh.prefetch = DocumentModelFactory.getPrefetch(doc, prefetchInfo, docSchemas);
        }
        if ((flags & 1) != 0) {
            refresh.lifeCycleState = doc.getLifeCycleState();
            refresh.lifeCyclePolicy = doc.getLifeCyclePolicy();
            refresh.isCheckedOut = doc.isCheckedOut();
            refresh.isLatestVersion = doc.isLatestVersion();
            refresh.isMajorVersion = doc.isMajorVersion();
            refresh.isLatestMajorVersion = doc.isLatestMajorVersion();
            refresh.isVersionSeriesCheckedOut = doc.isVersionSeriesCheckedOut();
            refresh.versionSeriesId = doc.getVersionSeriesId();
            refresh.checkinComment = doc.getCheckinComment();
        }
        if ((flags & 0x100) != 0) {
            if (schemas == null) {
                schemas = docSchemas.toArray(new String[0]);
            }
            TypeProvider typeProvider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
            DocumentPart[] parts = new DocumentPart[schemas.length];
            for (int i = 0; i < schemas.length; ++i) {
                DocumentPartImpl part = new DocumentPartImpl(typeProvider.getSchema(schemas[i]));
                doc.readDocumentPart((DocumentPart)part);
                parts[i] = part;
            }
            refresh.documentParts = parts;
        }
        return refresh;
    }

    protected static Prefetch getPrefetch(Document doc, PrefetchInfo prefetchInfo, Set<String> docSchemas) {
        String[] prefetchSchemas;
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        HashSet<String> xpaths = new HashSet<String>();
        String[] prefetchFields = prefetchInfo.getFields();
        if (prefetchFields != null) {
            xpaths.addAll(Arrays.asList(prefetchFields));
        }
        if ((prefetchSchemas = prefetchInfo.getSchemas()) != null) {
            for (String schemaName : prefetchSchemas) {
                Schema schema;
                if (!docSchemas.contains(schemaName) || (schema = schemaManager.getSchema(schemaName)) == null) continue;
                for (Field field : schema.getFields()) {
                    if (!DocumentModelFactory.isScalarField(field)) continue;
                    xpaths.add(field.getName().getPrefixedName());
                }
            }
        }
        Prefetch prefetch = new Prefetch();
        for (String schemaName : docSchemas) {
            Schema schema = schemaManager.getSchema(schemaName);
            HashSet<String> schemaXpaths = new HashSet<String>();
            for (String xpath : xpaths) {
                String sn = DocumentModelImpl.getXPathSchemaName((String)xpath, docSchemas, null);
                if (!schemaName.equals(sn)) continue;
                schemaXpaths.add(xpath);
            }
            if (schemaXpaths.isEmpty()) continue;
            Map<String, Serializable> map = doc.readPrefetch((ComplexType)schema, schemaXpaths);
            for (Map.Entry<String, Serializable> en : map.entrySet()) {
                String xpath = en.getKey();
                Serializable value = en.getValue();
                String[] returnName = new String[1];
                String sn = DocumentModelImpl.getXPathSchemaName((String)xpath, docSchemas, (String[])returnName);
                String name = returnName[0];
                prefetch.put(xpath, sn, name, value);
            }
        }
        return prefetch;
    }

    protected static boolean isScalarField(Field field) {
        Type type = field.getType();
        if (type.isComplexType()) {
            return false;
        }
        if (!type.isListType()) {
            return true;
        }
        return ((ListType)type).getFieldType().isSimpleType();
    }

    public static DocumentModel createDocumentModel(String type, String id) {
        SchemaManager sm = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DocumentType docType = sm.getDocumentType(type);
        DocumentModelImpl doc = new DocumentModelImpl(null, docType.getName(), id, null, null, (DocumentRef)new IdRef(id), null, null, null, null, null);
        for (Schema schema : docType.getSchemas()) {
            doc.addDataModel(DocumentModelFactory.createDataModel(null, schema));
        }
        return doc;
    }
}

