/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.workflow.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.task.CreateTask;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.workflow.services.CommentsModerationService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.DocumentTaskProvider;
import org.nuxeo.runtime.api.Framework;

public class CommentsModerationServiceImpl
implements CommentsModerationService {
    private static final Log log = LogFactory.getLog(CommentsModerationService.class);

    public void startModeration(CoreSession session, DocumentModel doc, String commentID, ArrayList<String> moderators) {
        TaskService taskService = (TaskService)Framework.getService(TaskService.class);
        if (moderators == null || moderators.isEmpty()) {
            throw new NuxeoException("No moderators defined");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("commentId", commentID);
        vars.put(Task.TaskVariableName.needi18n.name(), "true");
        vars.put(Task.TaskVariableName.taskType.name(), "comment_moderation");
        vars.put(CreateTask.OperationTaskVariableName.createdFromCreateTaskOperation.name(), "false");
        vars.put(CreateTask.OperationTaskVariableName.acceptOperationChain.name(), "acceptComment");
        vars.put(CreateTask.OperationTaskVariableName.rejectOperationChain.name(), "rejectComment");
        taskService.createTask(session, (NuxeoPrincipal)session.getPrincipal(), doc, "moderate", moderators, false, null, null, null, vars, null);
    }

    public Task getModerationTask(TaskService taskService, CoreSession session, DocumentModel doc, String commentId) {
        List tasks = DocumentTaskProvider.getTasks((String)"GET_COMMENT_MODERATION_TASKS", (CoreSession)session, (boolean)false, null, (Object[])new Object[]{doc.getId(), session.getPrincipal().getName(), commentId});
        if (tasks != null && !tasks.isEmpty()) {
            if (tasks.size() > 1) {
                log.error((Object)"There are several moderation workflows running, taking only first found");
            }
            Task task = (Task)tasks.get(0);
            return task;
        }
        return null;
    }

    public void approveComent(CoreSession session, DocumentModel doc, String commentId) {
        TaskService taskService = (TaskService)Framework.getService(TaskService.class);
        Task moderationTask = this.getModerationTask(taskService, session, doc, commentId);
        if (moderationTask == null) {
            session.followTransition((DocumentRef)new IdRef(commentId), "moderation_publish");
        } else {
            taskService.acceptTask(session, (NuxeoPrincipal)session.getPrincipal(), moderationTask, null);
        }
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("emailDetails", "test");
        this.notifyEvent(session, "commentPublished", null, null, null, doc);
    }

    public void rejectComment(CoreSession session, DocumentModel doc, String commentId) {
        TaskService taskService = (TaskService)Framework.getService(TaskService.class);
        Task moderationTask = this.getModerationTask(taskService, session, doc, commentId);
        if (moderationTask == null) {
            session.followTransition((DocumentRef)new IdRef(commentId), "moderation_reject");
        } else {
            taskService.rejectTask(session, (NuxeoPrincipal)session.getPrincipal(), moderationTask, null);
        }
    }

    public void publishComment(CoreSession session, DocumentModel comment) {
        session.followTransition(comment.getRef(), "moderation_publish");
        this.notifyEvent(session, "commentPublished", null, null, null, comment);
    }

    protected void notifyEvent(CoreSession session, String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm) {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        properties.put("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        properties.put("sessionId", (Serializable)((Object)session.getSessionId()));
        properties.put("documentLifeCycle", (Serializable)((Object)dm.getCurrentLifeCycleState()));
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), dm);
        ctx.setProperties(properties);
        ctx.setComment(comment);
        ctx.setCategory(category);
        EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        Event event = ctx.newEvent(eventId);
        evtProducer.fireEvent(event);
    }
}

