/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="lock", type="LockService", targetType="Document")
public class LockService
extends DefaultAdapter {
    @GET
    public Object doGet() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            Lock lock = this.ctx.getCoreSession().getLockInfo(doc.getRef());
            return lock.getOwner() + '/' + ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lock.getCreated()));
        }
        catch (NuxeoException e) {
            throw WebException.wrap((String)"Failed to get lock on document", (Throwable)e);
        }
    }

    @DELETE
    public Object removeLock() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().removeLock(doc.getRef());
            doc.refresh();
            return null;
        }
        catch (NuxeoException e) {
            throw WebException.wrap((String)"Failed to unlock document", (Throwable)e);
        }
    }

    @POST
    public Object doPost() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().setLock(doc.getRef());
            doc.refresh();
            return null;
        }
        catch (NuxeoException e) {
            throw WebException.wrap((String)"Failed to lock document", (Throwable)e);
        }
    }
}

