/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.rest;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class UserProfileEnricher
extends AbstractJsonEnricher<NuxeoPrincipal> {
    public static final String NAME = "userprofile";

    public UserProfileEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, NuxeoPrincipal nuxeoPrincipal) throws IOException {
        UserProfileService ups = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        try (RenderingContext.SessionWrapper sw = this.ctx.getSession(null);){
            DocumentModel up = ups.getUserProfileDocument(nuxeoPrincipal.getName(), sw.getSession());
            jg.writeFieldName(NAME);
            if (up == null) {
                jg.writeNull();
            } else {
                jg.writeStartObject();
                jg.writeStringField("birthdate", (String)((Object)up.getPropertyValue("userprofile:birthdate")));
                jg.writeStringField("phonenumber", (String)((Object)up.getPropertyValue("userprofile:phonenumber")));
                Blob avatar = (Blob)up.getPropertyValue("userprofile:avatar");
                if (avatar != null) {
                    DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
                    String url = downloadService.getDownloadUrl(up, "userprofile:avatar", avatar.getFilename());
                    jg.writeStringField("avatar", this.ctx.getBaseUrl() + url);
                } else {
                    jg.writeNullField("avatar");
                }
                jg.writeEndObject();
            }
        }
    }
}

