/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.localconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="typesConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UITypesConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected transient SchemaManager schemaManager;

    public List<Type> getNotSelectedTypes() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getNotSelectedTypes(currentDoc);
    }

    public List<Type> getNotSelectedTypes(DocumentModel document) {
        if (!document.hasFacet("UITypesLocalConfiguration")) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = this.getAllowedTypes(document);
        ArrayList<Type> notSelectedTypes = new ArrayList<Type>(this.typeManager.findAllAllowedSubTypesFrom(document.getType()));
        Iterator it = notSelectedTypes.iterator();
        while (it.hasNext()) {
            Type type = (Type)it.next();
            if (!allowedTypes.contains(type.getId())) continue;
            it.remove();
        }
        Collections.sort(notSelectedTypes, new TypeLabelAlphabeticalOrder(this.messages));
        return notSelectedTypes;
    }

    protected List<String> getAllowedTypes(DocumentModel doc) {
        UITypesConfiguration uiTypesConfiguration = (UITypesConfiguration)doc.getAdapter(UITypesConfiguration.class);
        if (uiTypesConfiguration == null) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = new ArrayList<String>(uiTypesConfiguration.getAllowedTypes());
        if (allowedTypes.isEmpty()) {
            allowedTypes = this.computeAllowedTypes(doc);
        }
        return allowedTypes;
    }

    public List<Type> getSelectedTypes() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getSelectedTypes(currentDoc);
    }

    public List<Type> getSelectedTypes(DocumentModel document) {
        if (!document.hasFacet("UITypesLocalConfiguration")) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = this.getAllowedTypes(document);
        ArrayList<Type> selectedTypes = new ArrayList<Type>();
        for (String type : allowedTypes) {
            Type existingType = this.typeManager.getType(type);
            if (existingType == null) continue;
            selectedTypes.add(existingType);
        }
        Collections.sort(selectedTypes, new TypeLabelAlphabeticalOrder(this.messages));
        return selectedTypes;
    }

    protected List<String> computeAllowedTypes(DocumentModel currentDoc) {
        ArrayList<String> types = new ArrayList<String>();
        DocumentModel parent = this.documentManager.getRootDocument();
        DocumentRef parentRef = currentDoc.getParentRef();
        if (parentRef != null && this.documentManager.hasPermission(parentRef, "Read")) {
            parent = this.documentManager.getDocument(parentRef);
        }
        for (Type type : this.typeManager.findAllAllowedSubTypesFrom(currentDoc.getType(), parent)) {
            types.add(type.getId());
        }
        return types;
    }

    public List<Type> getTypesWithSchemaFile() {
        DocumentModel document = this.navigationContext.getCurrentDocument();
        return this.getTypesWithSchemaFile(document);
    }

    public List<Type> getTypesWithSchemaFile(DocumentModel document) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (String type : this.getAllowedTypes(document)) {
            DocumentType documentType = this.getSchemaManager().getDocumentType(type);
            if (documentType == null || !documentType.hasSchema("file")) continue;
            types.add(this.typeManager.getType(type));
        }
        Collections.sort(types, new TypeLabelAlphabeticalOrder(this.messages));
        return Collections.unmodifiableList(types);
    }

    protected SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    protected static class TypeLabelAlphabeticalOrder
    implements Comparator<Type> {
        private static final Log log = LogFactory.getLog(TypeLabelAlphabeticalOrder.class);
        private final Map<String, String> messages;

        public TypeLabelAlphabeticalOrder(Map<String, String> messages) {
            this.messages = messages;
        }

        @Override
        public int compare(Type type1, Type type2) {
            return this.getTranslatedLabel(type1).compareTo(this.getTranslatedLabel(type2));
        }

        protected String getTranslatedLabel(Type type) {
            String label = type.getLabel();
            if (label == null) {
                String typeId = type.getId();
                log.error((Object)String.format("No label for the %s type, using its id instead.", typeId));
                return typeId;
            }
            String translatedLabel = this.messages.get(label);
            if (translatedLabel == null) {
                return label;
            }
            return translatedLabel;
        }
    }
}

