/*
 * (C) Copyright 2016 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Gabriel Barata <gbarata@nuxeo.com>
 */
package org.nuxeo.ecm.automation.jaxrs.io.operations;

import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;

/**
 * Resolves a list of blobs passed by key as input of an operation.
 *
 * @since 8.4
 */
public class BlobsInputResolver implements InputResolver<BlobList> {

    @Override
    public String getType() {
        return "blobs";
    }

    @Override
    public BlobList getInput(String content) {
        String[] array = StringUtils.split(content, ',', true);
        BlobList list = new BlobList(array.length);
        for (String key : array) {
            list.add(BlobInputResolver.blobFromKey(key));
        }
        return list;
    }
}
