/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services.enricher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.io.services.enricher.AbstractContentEnricher;
import org.nuxeo.ecm.automation.io.services.enricher.RestEvaluationContext;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public class VocabularyEnricher
extends AbstractContentEnricher {
    protected static final Log log = LogFactory.getLog(VocabularyEnricher.class);
    public static final String DIRECTORY_DEFAULT_LABEL_PREFIX = "label_";
    public static final String KEY_SEPARATOR = "/";
    public static final String FIELD_PARAMETER = "field";
    public static final String DIRECTORY_PARAMETER = "directoryName";
    private String field;
    private String directoryName;
    private DirectoryService directoryService;

    @Override
    public void enrich(JsonGenerator jg, RestEvaluationContext ec) throws IOException {
        DocumentModel doc = ec.getDocumentModel();
        jg.writeStartObject();
        try {
            List<String> labelFields = this.getLabelFields(this.directoryName);
            String[] entriesIds = VocabularyEnricher.getPropertyValues(doc, this.field);
            jg.writeFieldName(this.field);
            jg.writeStartArray();
            if (entriesIds != null) {
                this.writeLabels(jg, this.directoryName, entriesIds, labelFields);
            }
            jg.writeEndArray();
        }
        catch (PropertyNotFoundException | DirectoryException e) {
            log.error((Object)e.getMessage());
        }
        jg.writeEndObject();
        jg.flush();
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.field = parameters.get(FIELD_PARAMETER);
        if (this.field == null || this.field.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'field' cannot be empty");
        }
        this.directoryName = parameters.get(DIRECTORY_PARAMETER);
        if (this.directoryName == null || this.directoryName.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'directoryName' cannot be empty");
        }
    }

    private void writeLabels(JsonGenerator jg, String directoryName, String[] entriesIds, List<String> labelFields) throws IOException {
        try (Session session = this.getDirectoryService().open(directoryName);){
            for (String entryId : entriesIds) {
                Map<String, String> labels = VocabularyEnricher.getAbsoluteLabels(entryId, session, labelFields);
                jg.writeStartObject();
                jg.writeStringField("id", entryId);
                for (Map.Entry<String, String> label : labels.entrySet()) {
                    jg.writeStringField(label.getKey(), label.getValue());
                }
                jg.writeEndObject();
            }
        }
    }

    private List<String> getLabelFields(String directoryName) {
        String schemaName = this.getDirectoryService().getDirectorySchema(directoryName);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(schemaName);
        ArrayList<String> labelFields = new ArrayList<String>();
        for (Field field : schema.getFields()) {
            String fieldName = field.getName().toString();
            if (!fieldName.startsWith(DIRECTORY_DEFAULT_LABEL_PREFIX)) continue;
            labelFields.add(fieldName);
        }
        return labelFields;
    }

    private DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        }
        return this.directoryService;
    }

    private static String[] getPropertyValues(DocumentModel doc, String fieldName) {
        String[] entriesIds = null;
        Property prop = doc.getProperty(fieldName);
        if (prop.isList()) {
            entriesIds = (String[])prop.getValue(String[].class);
        } else {
            String value = (String)prop.getValue(String.class);
            if (value != null) {
                entriesIds = new String[]{value};
            }
        }
        return entriesIds;
    }

    private static Map<String, String> getAbsoluteLabels(String entryId, Session session, List<String> labelFields) {
        String[] split = entryId.split(KEY_SEPARATOR);
        HashMap<String, String> labels = new HashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            DocumentModel entry = session.getEntry(split[i]);
            if (entry == null) continue;
            for (String labelField : labelFields) {
                String result = (String)labels.get(labelField);
                if (result == null) {
                    result = "";
                }
                String value = (String)((Object)entry.getPropertyValue(labelField));
                result = result + (i > 0 ? KEY_SEPARATOR : "") + value;
                labels.put(labelField, result);
            }
        }
        return labels;
    }
}

