/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.el.ELService;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Repository.PageProvider", category="Fetch", label="PageProvider", description="Perform a query or a named provider query on the repository. Result is paginated. The query result will become the input for the next operation. If no query or provider name is given, a query returning all the documents that the user has access to will be executed.", aliases={"Document.PageProvider"})
public class DocumentPageProviderOperation {
    public static final String ID = "Repository.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    private static final String SORT_PARAMETER_SEPARATOR = " ";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    private static final Log log = LogFactory.getLog(DocumentPageProviderOperation.class);
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService ppService;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Deprecated
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    @Deprecated
    protected Integer page;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Deprecated
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", alias={"searchTerm"}, required=false)
    protected StringList strParameters;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;
    @Param(name="maxResults", required=false)
    protected String maxResults = "100";
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected String sortBy;
    @Param(name="quotePatternParameters", required=false, description="Quote query parameters if the query is specified")
    protected boolean quotePatternParameters = true;
    @Param(name="escapePatternParameters", required=false, description="Escape query parameters if the query is specified")
    protected boolean escapePatternParameters = true;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected String sortOrder;

    @OperationMethod
    public PaginableDocumentModelListImpl run() throws OperationException {
        PaginableDocumentModelListImpl res;
        ArrayList<SortInfo> sortInfos = null;
        if (this.sortInfoAsStringList != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(SORT_PARAMETER_SEPARATOR)) {
                    String[] parts = sortInfoDesc.split(SORT_PARAMETER_SEPARATOR);
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        } else if (!StringUtils.isBlank((String)this.sortBy)) {
            sortInfos = new ArrayList();
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((String)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && StringUtils.isBlank((String)this.providerName)) {
            this.query = "SELECT * from Document";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        if (this.currentPageIndex != null) {
            targetPage = this.currentPageIndex.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        DocumentModel searchDocumentModel = DocumentPageProviderOperation.getSearchDocumentModel(this.session, this.ppService, this.providerName, this.namedParameters);
        if (this.query != null) {
            CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
            desc.setPattern(this.query);
            desc.setQuotePatternParameters(this.quotePatternParameters);
            desc.setEscapePatternParameters(this.escapePatternParameters);
            if (this.maxResults != null && !this.maxResults.isEmpty() && !this.maxResults.equals("-1")) {
                desc.getProperties().put("maxResults", this.maxResults);
            }
            PageProvider pp = this.ppService.getPageProvider("", (PageProviderDefinition)desc, searchDocumentModel, sortInfos, targetPageSize, targetPage, props, parameters);
            res = new PaginableDocumentModelListImpl(pp, this.documentLinkBuilder);
        } else {
            parameters = this.resolveParameters(parameters);
            PageProvider pp = this.ppService.getPageProvider(this.providerName, searchDocumentModel, sortInfos, targetPageSize, targetPage, props, parameters);
            res = new PaginableDocumentModelListImpl(pp, this.documentLinkBuilder);
        }
        if (res.hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }

    private Object[] resolveParameters(Object[] parameters) {
        ActionContext actionContext = (ActionContext)this.context.get((Object)"seamActionContext");
        if (actionContext == null) {
            return parameters;
        }
        PageProviderDefinition ppDef = this.ppService.getPageProviderDefinition(this.providerName);
        String[] params = ppDef.getQueryParameters();
        if (params == null) {
            params = new String[]{};
        }
        Object[] resolvedParams = new Object[params.length + (parameters != null ? parameters.length : 0)];
        ELContext elContext = ((ELService)Framework.getService(ELService.class)).createELContext();
        int i = 0;
        if (parameters != null) {
            i = parameters.length;
            System.arraycopy(parameters, 0, resolvedParams, 0, i);
        }
        for (int j = 0; j < params.length; ++j) {
            ValueExpression ve = ELActionContext.EXPRESSION_FACTORY.createValueExpression(elContext, params[j], Object.class);
            resolvedParams[i + j] = ve.getValue(elContext);
        }
        return resolvedParams;
    }

    public static DocumentModel getSearchDocumentModel(CoreSession session, PageProviderService pps, String providerName, Properties namedParameters) {
        SimpleDocumentModel searchDocumentModel = null;
        if (!StringUtils.isBlank((String)providerName)) {
            PageProviderDefinition pageProviderDefinition = pps.getPageProviderDefinition(providerName);
            if (pageProviderDefinition != null) {
                String searchDocType = pageProviderDefinition.getSearchDocumentType();
                if (searchDocType != null) {
                    searchDocumentModel = session.createDocumentModel(searchDocType);
                } else if (pageProviderDefinition.getWhereClause() != null) {
                    searchDocumentModel = new SimpleDocumentModel();
                }
            } else {
                log.error((Object)("No page provider definition found for " + providerName));
            }
        }
        if (namedParameters != null && !namedParameters.isEmpty()) {
            if (searchDocumentModel == null) {
                searchDocumentModel = new SimpleDocumentModel();
            }
            for (Map.Entry entry : namedParameters.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    DocumentHelper.setProperty((CoreSession)session, (DocumentModel)searchDocumentModel, (String)key, (String)value, (boolean)true);
                }
                catch (IOException | PropertyNotFoundException e) {}
            }
            searchDocumentModel.putContextData("namedParameters", (Serializable)namedParameters);
        }
        return searchDocumentModel;
    }
}

