/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageUtils {
    public static final String SYMBOLIC_NAME_PATTERN = "[a-zA-Z_]+.*";
    public static final String VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+(-.+)?";
    public static final Pattern NAME = Pattern.compile("([a-zA-Z_]+.*)-(\\d+\\.\\d+\\.\\d+(-.+)?)");

    private PackageUtils() {
    }

    public static String getPackageName(String packageId) {
        Matcher matcher = NAME.matcher(packageId);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public static String getPackageVersion(String packageId) {
        Matcher matcher = NAME.matcher(packageId);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(2);
    }

    public static boolean isValidPackageId(String packageId) {
        return PackageUtils.getPackageName(packageId) != null && PackageUtils.getPackageVersion(packageId) != null;
    }
}

