/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.HttpClientBuilderHelper;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.response.TrialErrorResponse;
import org.nuxeo.connect.registration.response.TrialRegistrationResponse;

public class RegistrationHelper {
    public static final String GET_PROJECTS_SUFFIX = "getAvailableProjectsForRegistration";
    public static final String POST_REGISTER_SUFFIX = "remoteRegisterInstance";
    protected static final Log log = LogFactory.getLog(RegistrationHelper.class);
    protected static List<String> ALLOWED_TRIAL_FIELDS = Arrays.asList("termsAndConditions", "company", "email", "login", "connectreg:projectName", "firstName", "lastName");

    protected static String getBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl();
    }

    protected static HttpClientContext getHttpClientContext(String url, String login, String password) {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (login != null) {
            UsernamePasswordCredentials ba = new UsernamePasswordCredentials(login, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)ba);
        }
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        try {
            authCache.put(URIUtils.extractHost((URI)new URI(url)), (AuthScheme)basicAuth);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        context.setAuthCache((AuthCache)authCache);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(10000).setCookieSpec("standard");
        ProxyHelper.configureProxyIfNeeded(requestConfigBuilder, (CredentialsProvider)credentialsProvider, url);
        context.setRequestConfig(requestConfigBuilder.build());
        return context;
    }

    public static List<ConnectProject> getAvailableProjectsForRegistration(String login, String password) {
        String url = RegistrationHelper.getBaseUrl() + GET_PROJECTS_SUFFIX;
        ArrayList<ConnectProject> result = new ArrayList<ConnectProject>();
        try (CloseableHttpClient httpClient = HttpClientBuilderHelper.getHttpClientBuilder(null, null, url).build();
             CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(url), (HttpContext)RegistrationHelper.getHttpClientContext(url, login, password));){
            int rc = httpResponse.getStatusLine().getStatusCode();
            if (rc == 200) {
                HttpEntity responseEntity = httpResponse.getEntity();
                if (responseEntity != null) {
                    String json = EntityUtils.toString((HttpEntity)responseEntity);
                    JSONArray array = new JSONArray(json);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject ob = (JSONObject)array.get(i);
                        result.add(AbstractJSONSerializableData.loadFromJSON(ConnectProject.class, ob));
                    }
                }
            } else {
                log.error((Object)("Unhandled response code: " + rc));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            log.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String remoteRegisterInstance(String login, String password, String prjId, NuxeoClientInstanceType type, String description) {
        String url = RegistrationHelper.getBaseUrl() + POST_REGISTER_SUFFIX;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("projectId", prjId));
        nvps.add(new BasicNameValuePair("description", description));
        nvps.add(new BasicNameValuePair("type", type.getValue()));
        nvps.add(new BasicNameValuePair("CTID", TechnicalInstanceIdentifier.instance().getCTID()));
        HttpPost method = new HttpPost(url);
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try (CloseableHttpClient httpClient = HttpClientBuilderHelper.getHttpClientBuilder(null, null, url).build();
             CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)RegistrationHelper.getHttpClientContext(url, login, password));){
            int rc = httpResponse.getStatusLine().getStatusCode();
            if (rc == 200) {
                HttpEntity responseEntity = httpResponse.getEntity();
                String string = responseEntity == null ? null : EntityUtils.toString((HttpEntity)responseEntity);
                return string;
            }
            log.error((Object)("Unhandled response code: " + rc));
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TrialRegistrationResponse remoteTrialInstanceRegistration(Map<String, String> parameters) {
        String url = ConnectUrlConfig.getTrialRegistrationBaseUrl() + "submit?embedded=true";
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!ALLOWED_TRIAL_FIELDS.contains(entry.getKey())) {
                log.debug((Object)("Skipped field: " + entry.getKey() + " (" + entry.getValue() + ")"));
                continue;
            }
            nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        HttpPost method = new HttpPost(url);
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try (CloseableHttpClient httpClient = HttpClientBuilderHelper.getHttpClientBuilder(null, null, url).build();
             CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)RegistrationHelper.getHttpClientContext(url, null, null));){
            int rc = httpResponse.getStatusLine().getStatusCode();
            log.debug((Object)("Registration response code: " + rc));
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity == null) return TrialErrorResponse.UNKNOWN();
            String body = EntityUtils.toString((HttpEntity)responseEntity);
            if (rc == 200) {
                TrialRegistrationResponse trialRegistrationResponse = TrialRegistrationResponse.read(body);
                return trialRegistrationResponse;
            }
            if (rc == 400) {
                TrialRegistrationResponse trialRegistrationResponse = TrialRegistrationResponse.read(body);
                return trialRegistrationResponse;
            }
            log.error((Object)("Unhandled response code: " + rc));
            return TrialErrorResponse.UNKNOWN();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

