/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.registration.response.TrialErrorResponse;

public class RegistrationException
extends Exception {
    private static final long serialVersionUID = -8586515796778400401L;
    private TrialErrorResponse error;

    public RegistrationException(TrialErrorResponse error) {
        super(error.getMessage());
        this.error = error;
    }

    public RegistrationException(String message) {
        super(message);
        this.error = TrialErrorResponse.UNKNOWN();
    }

    public RegistrationException(Throwable e) {
        super(e);
        this.error = TrialErrorResponse.UNKNOWN();
    }

    public List<TrialErrorResponse.Error> getErrors() {
        return this.error.getErrors();
    }

    public List<String> getErrorsMessages() {
        ArrayList<String> msg = new ArrayList<String>();
        for (TrialErrorResponse.Error err : this.error.getErrors()) {
            msg.add(err.getMessage());
        }
        return msg;
    }
}

